package ohd.hseb.ohdmodels.muskrout;

import ohd.hseb.util.fews.ohdmodels.ModelState;

public class MuskroutModelState extends ModelState
{
    public static final String INITIAL_INFLOW_TAG = "INITIAL_INFLOW";
    public static final String INITIAL_OUTFLOW_TAG = "INITIAL_OUTFLOW";
    public static final String[] initialFlows = {INITIAL_INFLOW_TAG, INITIAL_OUTFLOW_TAG};
    public static final int INFLOW = 0;
    public static final int OUTFLOW = 1;
    private double _initialInflowCarryover = 0.0;
    private double _initialOutflowCaryover = 0.0;

    public MuskroutModelState()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.fews.State#extractValuesFromMap()
     */
    @Override
    public void extractValuesFromMap() throws Exception
    {
        _initialInflowCarryover = super.getDoubleDataState(INITIAL_INFLOW_TAG);
        _initialOutflowCaryover = super.getDoubleDataState(INITIAL_OUTFLOW_TAG);
    }

    /**
     * @return the initialInflowCarryover
     */
    public double getInitialInflowCarryover()
    {
        return _initialInflowCarryover;
    }

    /**
     * @return the initialOutflowCaryover
     */
    public double getInitialOutflowCaryover()
    {
        return _initialOutflowCaryover;
    }

    /**
     * @param initialInflowCarryover the initialInflowCarryover to set
     */
    public void setInitialInflowCarryover(final double initialInflowCarryover)
    {
        this._initialInflowCarryover = initialInflowCarryover;
    }

    /**
     * @param initialOutflowCaryover the initialOutflowCaryover to set
     */
    public void setInitialOutflowCaryover(final double initialOutflowCaryover)
    {
        this._initialOutflowCaryover = initialOutflowCaryover;
    }

    /**
     * Set the values from local variables to map in parent class
     */
    public void setCarryOverValues()
    {
        super.setStateValue(INITIAL_INFLOW_TAG, _initialInflowCarryover);
        super.setStateValue(INITIAL_OUTFLOW_TAG, _initialOutflowCaryover);

    }

}