package ohd.hseb.ohdmodels.resj;

import java.util.List;

import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.SortedProperties;
import ohd.hseb.util.fews.NwsrfsDataFileExtractor;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.State;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

/**
 * @author champ
 */
public class ResjModelDriver extends ModelDriver
{
    private static final String _RESJ_EXE_NAME = "resj";

    public ResjModelDriver()
    {
        super(); //calling ModelDriver constructor

        _parameters = new ResjModelParameters();
        _state = new ResjModelState();
        _savedParameters = new ResjModelParameters();
    }

    @Override
    public ResjModelParameters getParameters()
    {
        return (ResjModelParameters)_parameters;
    }

    @Override
    public ResjModelParameters getPreviousParameters()
    {
        return (ResjModelParameters)_savedParameters;
    }

    @Override
    public ResjModelState getState()
    {
        return (ResjModelState)_state;
    }

    @Override
    public void execute() throws Exception
    {
        // All input time series don't have the same time step
        // pick the input ts with DISCHARGE dimension code and smallest time step

        int minimumTimeStep = 999;
        for(int listIndex = 0; listIndex < _tsList.size(); listIndex++)
        {
            if(_tsList.get(listIndex).getMeasuringUnit().getType() == MeasuringUnitType.discharge)
            {
                //the validate needs to validate this is there
                if(_tsList.get(listIndex).getIntervalInHours() < minimumTimeStep)
                {
                    _drivingTs = _tsList.get(listIndex);
                    minimumTimeStep = _tsList.get(listIndex).getIntervalInHours();
                    _logger.log(Logger.DEBUG, "Driving Time Series set to " + _drivingTs.getLocationId() + " "
                        + _drivingTs.getTimeSeriesType() + " " + _drivingTs.getIntervalInHours());
                }
            }
        }

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        // Convert the inputs in XML file to flat file (ts.txt, params.txt and stateI.txt) to work directory
        final LegacyModelAdapter resjAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        resjAdapter.writeStandAloneFiles();

        final NwsrfsDataFileExtractor extractor = new NwsrfsDataFileExtractor(getWorkDir());

        final String DATAUNIT_PATH_FILENAME = extractor.getDataUnitFullPathForLegacyModels();

        final SortedProperties properties = new SortedProperties();
        properties.put(LegacyModelAdapter.DATA_UNIT_FILE_NAME, DATAUNIT_PATH_FILENAME);

        //Clear out state Map before storing the new data (bug 244)
        ((State)_state).getStateMap().clear();

        // Execute RES-J model
        resjAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + _RESJ_EXE_NAME, properties);

        // Load the state results 
        getState().loadState(resjAdapter.getOutputStateFileName(), _logger);

        //Set state date and time
        getState().setDateTime(getComputationEndTime());

        // Read time series (ts.txt)
        final List<RegularTimeSeries> resultsList = resjAdapter.readOutputFlatFilesToLists();

        // qualifier id is part of unique key NOT location id
        // this is because can have multiple outputs with same type

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }
    }

}
