package ohd.hseb.ohdmodels.resj;

import ohd.hseb.util.fews.ohdmodels.LegacyModelParameters;

/**
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * 
 */
final public class ResjModelParameters extends LegacyModelParameters
{
	public final static String RES_J = "RES-J";
	public final static String TIMESERIES = "TIMESERIES";
	public final static String TOPOLOGY = "TOPOLOGY";
	public final static String PARAMETERS = "PARAMETERS";
	public final static String RULES  = "RULES";
	public final static String TABLE = "TABLE";
	public final static String RESERVOIR = "RESERVOIR";
	public final static String ELEV = "ELEV";
	public final static String VALUES	= "VALUES";
	public final static String SETRELEASE = "SETRELEASE";
	public final static String MAXINCREASE = "MAXINCREASE";
	public final static String SETMIN = "SETMIN";
	public final static String SPILLWAY = "SPILLWAY";
	public final static String LOOKUP3 = "LOOKUP3";
	public final static String ADJUST = "ADJUST";
	
	
	public final static String[] tags =
	{
		RES_J,
		TIMESERIES, // 1
		TOPOLOGY, // 2
		PARAMETERS,// 3
		RULES, // 4
		TABLE, // 5
		RESERVOIR, // 6
		ELEV, // 7
		VALUES, // 8
		SETRELEASE, // 9
		MAXINCREASE, // 10
		SETMIN, // 11
		SPILLWAY, // 12
		LOOKUP3, // 13
		ADJUST	// 14
	};

	/**
	 * Get tag name index
	 * @param tag -- tag name
	 * @return tag name index
	 */
	public static int getTagIndex(String tag)
	{
		int index = -1;
		int tagLength = tags.length;
		for (int i = 0; i < tagLength; i++)
		{
			if (tag.equals(tags[i])) 
			{
				index = i;
				break;
			}				
		}
		return index;
	}
}