package ohd.hseb.ohdmodels.ressngl;

import ohd.hseb.util.fews.ohdmodels.LegacyModelParameters;

/**
 * @author champ
 * 
 */
final public class RessnglModelParameters extends LegacyModelParameters
{

	public final static String GENERAL = "GENERAL";
	public final static String ENDGENL = "ENDGENL";	
	public final static String PARMS = "PARMS";
	public final static String ENDP = "ENDP";
	public final static String TS = "TS";
	public final static String ENDT = "ENDT";
	public final static String TIME_SERIES = "TIME-SERIES";
	public final static String ENDTS = "ENDTS";
	public final static String CO = "CO";
	public final static String ENDCO = "ENDCO";
	public final static String CARRYOVER = "CARRYOVER";
	public final static String ENDC = "ENDC";
	public final static String RCL = "RCL";
	public final static String ENDRCL	 = "ENDRCL";
	public final static String SPECIFIC = "SPECIFIC";
	public final static String ENDSPEC = "ENDSPEC";
	public final static String SETQ = "SETQ";
	public final static String ENDSETQ = "ENDSETQ";
	public final static String SPILLWAY = "SPILLWAY";
	public final static String ENDSPWY = "ENDSPWY";
	public final static String ADJUST = "ADJUST";
	public final static String ENDADJ = "ENDADJ";
	public final static String BACKFLOW = "BACKFLOW";
	public final static String ENDBACK = "ENDBACK";
	public final static String INDSRCHGE = "INDSRCHGE";
	public final static String ENDINDS = "ENDINDS";
	public final static String RULEADJ = "RULEADJ";
	public final static String ENDRADJ = "ENDRADJ";
	public final static String STPOOLQ = "STPOOLQ";
	public final static String ENDSTPQ = "ENDSTPQ";
	public final static String SETMAX = "SETMAX";
	public final static String ENDSMAX = "ENDSMAX";
	public final static String RAINEVAP = "RAINEVAP";
	public final static String ENDRAIN = "ENDRAIN";
	public final static String IF = "IF";
	public final static String ENDIF = "ENDIF";
	public final static String POOLQ = "POOLQ";
	public final static String ENDPOOLQ	 = "ENDPOOLQ";
	public final static String RULECURVE = "RULECURVE";
	public final static String ENDRULE = "ENDRULE";
	
	public final static String TITLE = "TITLE";
	public final static String UNITS = "UNITS";
	
	public final static int index_PARMS = 1;
	public final static int index_TS = 2;
	public final static int index_TIME_SERIES = 3;
	public final static int index_CO = 4;
	public final static int index_CARRYOVER = 5;
	public final static int index_RCL = 6;
	public final static int index_IF = 17;
	
	public final static String[] openTags =
	{
		GENERAL, // 0
		PARMS,   // 1
		TS,      // 2
		TIME_SERIES, // 3
		CO,         //4
		CARRYOVER,  //5
		RCL,        // 6
		SPECIFIC,   // 7
		SETQ,       //8 
		SPILLWAY,   // 9
		ADJUST,     //10 
		BACKFLOW,   // 11
		INDSRCHGE,  //12
		RULEADJ,   //13
		STPOOLQ,	   //14	
		SETMAX,	// 15
		RAINEVAP, // 16
		IF,        // 17
		POOLQ,	// 18
		RULECURVE	//19
	};
	public final static String[] openTags1 =
	{
		GENERAL, // 0
		RCL,        // 6
		SPECIFIC,   // 7
		SETQ,       //8 
		SPILLWAY,   // 9
		ADJUST,     //10 
		BACKFLOW,   // 11
		INDSRCHGE,  //12
		RULEADJ,   //13
		STPOOLQ,	   //14	
		SETMAX,	// 15
		RAINEVAP, // 16
		IF,        // 17
		POOLQ,	// 18
		RULECURVE	//19
	};
	
	public static boolean isAnOpenTag(String tag, int which)
	{
		boolean openTag = false;
		if (which == 1)
		{
			for (int i = 0; i < openTags1.length; i++)
			{
				if (tag.equals(openTags1[i]))
				{
					openTag = true;
					break;
				}
			}
		} else
		{
			for (int i = 0; i < openTags.length; i++)
			{
				if (tag.equals(openTags[i]))
				{
					openTag = true;
					break;
				}
			}
		}
		return openTag;
	}
	
	public final static String[] endTags =
	{
		ENDGENL, // 0
		ENDP,    // 1
		ENDT,    // 2
		ENDTS,   // 3
		ENDC,   //4
		ENDCO,	// 5
		ENDRCL,  //6
		ENDSPEC, //7
		ENDSETQ, // 8
		ENDSPWY, //9
		ENDADJ,  //10
		ENDBACK, //11
		ENDINDS, //12
		ENDRADJ, //13
		ENDSTPQ,	 //14
		ENDSMAX, // 15
		ENDRAIN, // 16
		ENDIF,    // 17
		ENDPOOLQ,	// 18
		ENDRULE	// 19
	};
	
	public final static String[] theParameters =
	{
		"ELVSSTOR",
		"INTERP",
		"QVALUE",
		"TYPE",
		"REPLQ",
		"CREST",
		"ELVSQ",
		"PASSEL",
		"OPTION",
		"EVAP",
		"QGEN",
		"QSLUICE",
		"DIST",
		"POOLVSQ",
		"LINEAR",
		"CURVE",
		"BLEND",
		"QMAX",
		"PERIODS",
		"ELEVDIFF",
		"MAXQI",
		"SCQI",
		"SCEL",
		"SCQO",
		"DTABLE",
		"GATEOPEN",
		"GATEL",
		"GATEQ",
		"RULECURVE",
		"CFACTOR"
	};
	
	public final static String ELVSSTOR = "ELVSSTOR";
	public final static String ELVSQ = "ELVSQ";
	public final static String POOLVSQ = "POOLVSQ";
	public final static String CURVE = "CURVE";
	public final static String EVAP = "EVAP";
	public final static String DIST = "DIST";
	
	public final static String[] tableParameters =
	{
		ELVSSTOR,
		ELVSQ,
		EVAP,
		DIST,
		POOLVSQ,
		CURVE,
		"SCQI",
		"SCEL",
		"SCQO",
		"DTABLE",
		"GATEOPEN",
		"GATEL",
		"GATEQ"
	};
	
	public static boolean isATable(String name)
	{
		boolean returnValue = false;
		for (int i = 0; i < tableParameters.length; i++)
		{
			if (name.equals(tableParameters[i]))
			{
				returnValue = true;
				break;
			}
		}
		
		return returnValue;
	}
}
