package ohd.hseb.ohdmodels.rsnwelev;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

public class RsnwelevModelParameters extends ModelParameters
{

    public final static String RSEL_TS_ID = "RSEL_TS_ID";
    public final static String RSEL_TS_TYPE = "RSEL_TS_TYPE";
    public final static String RSEL_TS_TIME_STEP = "RSEL_TS_TIME_STEP";
    public final static String THRESHOLD_TEMPERATURE = "THRESHOLD_TEMPERATURE";
    public final static String LAPSE_RATE = "LAPSE_RATE";
    public final static String MAT_TS_ID = "MAT_TS_ID";
    public final static String MAT_TS_TYPE = "MAT_TS_TYPE";
    public final static String ELEVATION_OF_TEMPERATURE_DATA = "ELEVATION_OF_TEMPERATURE_DATA";
    public final static String FREEZING_LEVEL_TS_ID = "FREEZING_LEVEL_TS_ID";
    public final static String FREEZING_LEVEL_DATA_CODE = "FREEZING_LEVEL_DATA_CODE";
    public final static String CARRYOVER_FLAG = "CARRYOVER_FLAG";
    private int _intervalInHours;
    private double _elevationOfAirTemperatureInMeters;
    private double _lapseRate;
    private double _thresholdTemperature;
    private String _rainSnowElevationTimeseriesId;

    public RsnwelevModelParameters()
    {
        //empty
    }

    @Override
    public void extractValuesFromMap() throws Exception
    {

        _intervalInHours = getIntDataParameter(RSEL_TS_TIME_STEP);
        _elevationOfAirTemperatureInMeters = getDoubleDataParameter(ELEVATION_OF_TEMPERATURE_DATA);
        _lapseRate = getDoubleDataParameter(LAPSE_RATE);
        _thresholdTemperature = getDoubleDataParameter(THRESHOLD_TEMPERATURE);
        _rainSnowElevationTimeseriesId = getStringDataParameter(RSEL_TS_ID);

    }

    public int getIntervalInHours()
    {
        return _intervalInHours;
    }

    public double getElevationOfAirTempInMeters()
    {
        return _elevationOfAirTemperatureInMeters;
    }

    public double getLapseRate()
    {
        return _lapseRate;
    }

    public double getThresholdTemperature()
    {
        return _thresholdTemperature;
    }

    public String getRainSnowElevationTimeseriesId()
    {
        return _rainSnowElevationTimeseriesId;
    }

    /**
     * @throws ModelException
     * @throws Exception
     */
    public void validateParams() throws ModelException, Exception
    { //assuming isValidated() == false

        String errorMessage;

        if(isParamExisting(RSEL_TS_TIME_STEP) == false)
        {
            errorMessage = RSEL_TS_TIME_STEP + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(isParamExisting(ELEVATION_OF_TEMPERATURE_DATA) == false)
        {
            errorMessage = ELEVATION_OF_TEMPERATURE_DATA + " parameter is absent.";
            throw new ModelException(errorMessage);
        }

        if(isParamExisting(LAPSE_RATE) == false)
        {
            errorMessage = LAPSE_RATE + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(isParamExisting(THRESHOLD_TEMPERATURE) == false)
        {
            errorMessage = THRESHOLD_TEMPERATURE + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(isParamExisting(RSEL_TS_ID) == false)
        {
            errorMessage = RSEL_TS_ID + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        //if reach here, validation is successful
        _logger.log(Logger.DEBUG, "RsnwelevModelParameters has been validated!");

    } //close validateParams

}
