package ohd.hseb.ohdmodels.sacsma;

import ohd.hseb.util.fews.OHDConstants;

enum SOIL_MOISTURE_STORAGE
{
    /*
     * 5 soil moisture storages(SMZC): 1)UZTDEF(UZTWM-UZTWC); 2)UZFWC; 3)LZTDEF(LZTWM-LZTWC); 4)LZFSC; 5)LZFPC; So there
     * are three of them overlap with state(UZFWC, LZFSC and LZFPC)
     */
    UZTDEF("UZTDEF"), //UZTDEF = UZTWM - UZTWC
    UZFWC(OHDConstants.SAC_STATE_UZFWC), //
    LZTDEF("LZTDEF"), //LZTDEF = LZTWM - LZTWC
    LZFSC(OHDConstants.SAC_STATE_LZFSC), //
    LZFPC(OHDConstants.SAC_STATE_LZFPC);

    final private String _type; //will not be changed

    private SOIL_MOISTURE_STORAGE(final String type)
    {
        _type = type;
    }

    String getTypeName()
    {
        return _type;
    }
}
