package ohd.hseb.ohdmodels.sacsma;

import ohd.hseb.util.fews.OHDConstants;

/**
 * Some constants used for SacSma are located in {@link OHDConstants} because they are used in the code belonging to the
 * project ohdcommon.
 */
final public class SacSmaModelConstants
{
    private SacSmaModelConstants()
    {
        /*
         * This class only contains static constants, so an instance of this class should never be created. If not
         * providing this private constructor, users still can create objects of this class by using the invisible
         * default constructor provided by Java, which is wrong. Now, with this private constructor, the default
         * constructor by Java is destroyed. Now, nobody from outside of this class can create the object of this class
         */
    }

    public final static String PXADJ_TAG = "PXADJ";
    public final static String RSERV_TAG = "RSERV";
    public final static String SIDE_TAG = "SIDE";
    public final static String PFREE_TAG = "PFREE";
    public final static String LZPK_TAG = "LZPK";
    public final static String LZSK_TAG = "LZSK";
    public final static String EFC_TAG = "EFC";
    public final static String REXP_TAG = "REXP";
    public final static String ZPERC_TAG = "ZPERC";
    public final static String RIVA_TAG = "RIVA";
    public final static String ADIMP_TAG = "ADIMP";
    public final static String PCTIM_TAG = "PCTIM";
    public final static String UZK_TAG = "UZK";

    public final static String LZFSM_TAG = "LZFSM";
    public final static String LZTWM_TAG = "LZTWM";
    public final static String UZFWM_TAG = "UZFWM";
    public final static String PEADJ_TAG = "PEADJ";
    public final static String UZTWM_TAG = "UZTWM";

    public final static String MAPE_INPUT_TAG = "MAPE_INPUT"; //switch to decide if use MAPE optional input TS or not    
    public final static String SASC_INPUT_TAG = "SASC_INPUT_OPTION";
    public final static String RUNOFF_COMPOENT_INTERVAL_TAG = "RUNOFF_COMPONENT_INTERVAL"; //default is 24 hr    
    public final static String SMZC_INTERVAL_TAG = "SMZC_INTERVAL"; //default is 24hr    

    public final static String FRZE_INPUT_TAG = "FROZEN_GROUND_CALC_OPTION";
    //card F1
    public final static String WE_INPUT_TAG = "WE_INPUT_OPTION";
    public final static String FGIX_INTERVAL_TAG = "FGIX_TS_INTERVAL"; //optional, output FGIX TS interval default is same as RAIM

    //card F2
    public final static String CSOIL_TAG = "CSOIL";
    public final static String CSNOW_TAG = "CSNOW";
    public final static String GCH_TAG = "GCH";
    public final static String RTHAW_TAG = "RTHAW";
    public final static String FRTEMP_TAG = "FRTEMP";
    public final static String SATR_TAG = "SATR";
    public final static String FREXP_TAG = "FREXP";

    //if not using MAPE input ts(default case), the 12 values are ET-demand; if using MAPE ts, these values are PE-adjustment
    public final static String ETTDEC_TAG = "ETTDEC";
    public final static String ETTNOV_TAG = "ETTNOV";
    public final static String ETTOCT_TAG = "ETTOCT";
    public final static String ETTSEP_TAG = "ETTSEP";
    public final static String ETTAUG_TAG = "ETTAUG";
    public final static String ETTJUL_TAG = "ETTJUL";
    public final static String ETTJUN_TAG = "ETTJUN";
    public final static String ETTMAY_TAG = "ETTMAY";
    public final static String ETTAPR_TAG = "ETTAPR";
    public final static String ETTMAR_TAG = "ETTMAR";
    public final static String ETTFEB_TAG = "ETTFEB";
    public final static String ETTJAN_TAG = "ETTJAN";
    public final static String ET_DEMAND_TAG = "ET_DATA";
    public final static String ET_DEMAND_CURVE_TAG = "ET_DEMAND_CURVE";
    public final static String LZFPM_TAG = "LZFPM";

    //for 6 states percentage
    public final static String UZTWC_PERC = "UZTWC_PERC";
    public final static String UZFWC_PERC = "UZFWC_PERC";
    public final static String LZTWC_PERC = "LZTWC_PERC";
    public final static String LZFSC_PERC = "LZFSC_PERC";
    public final static String LZFPC_PERC = "LZFPC_PERC";
    public final static String ADIMC_PERC = "ADIMC_PERC";

    /**
     * FROST is a TECHNIQUE for SacSma. When it is present and its value is false, it over-writes the parameter which
     * sets to run Frozen Ground feature and turn it off.
     */
    public final static String FROST_TAG = "FROST";

    /** PRINTSMA is a TECHNIQUE for SacSma to print out the table like message */
    public static final String PRINTSMA = "PRINTSMA";

}
