package ohd.hseb.ohdmodels.sacsma;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import ohd.hseb.ohdmodels.snow17.Snow17ModelConstants;
import ohd.hseb.util.Logger;

/**
 * Immutable class: once the object was constructed through the constructor, its state cannot be modified. This suits
 * the SACSMA TECHNIQUE purpose: every technique has its default value. The optional presence in <properties> inside
 * run_info.xml can set the technique to the specified value.
 */

public class SacSmaTechnique
{
    private final Map<String, Boolean> _techniqueMap = new HashMap<String, Boolean>();

    public SacSmaTechnique(final Properties properties, final Logger log)
    {
        //set the default values first
        _techniqueMap.put(SacSmaModelConstants.PRINTSMA, false); //produces detailed daily information in the form of a text table, default is false
        _techniqueMap.put(Snow17ModelConstants.SACSNOW_FULL_VERSION, false); //for TECHNIQUE SACSNOW, default is Slim version
        _techniqueMap.put(SacSmaModelConstants.FROST_TAG, true); //controls whether FRZE algorithm should be used(it overrides the setting in params.xml), default is true

        //now, depends on properties in run_info.xml, could re-set some of the values
        for(final String techName: _techniqueMap.keySet())
        {
            if(properties.containsKey(techName))
            {
                final boolean boolValue = Boolean.parseBoolean(properties.getProperty(techName));

                _techniqueMap.put(techName, boolValue);
                log.log(Logger.DEBUG, "Using the Run Time Option: " + techName + "[" + boolValue + "]");
            }
        }
    }

    /**
     * Get the boolean value for the specific SNOW17 technique.
     */
    public boolean getBoolValue(final String techName)
    {
        return _techniqueMap.get(techName);
    }

}
