package ohd.hseb.ohdmodels.sacsmaHT;

/**
 * @author FewsPilot Team
 */
final class HeatTransferSimulation
{

    public HeatTransferSimulation(final SacSmaHTData sacHtData)
    {
        _sacHtData = sacHtData;
    }

    // so we can access parameters and state
    SacSmaHTData _sacHtData;

    Coefficients _coefficients = new Coefficients();

    public class CommonVariables
    {
        public double val;
    }

    class Coefficients
    {
        private final double[] _aCoefficients;
        private final double[] _bCoefficients;
        private final double[] _cCoefficients;

        Coefficients()
        {
            _aCoefficients = new double[SacSmaHTConstants.NSZ_ABC];
            _bCoefficients = new double[SacSmaHTConstants.NSZ_ABC];
            _cCoefficients = new double[SacSmaHTConstants.NSZ_ABC];
        }

        double[] getACoefficients()
        {
            return _aCoefficients;
        }

        void setACoefficients(final double[] aCoefficients)
        {
            int theLength = aCoefficients.length;

            for(int i = 0; i < theLength; i++)
            {
                _aCoefficients[i] = (float)aCoefficients[i];

            }
            // _aCoefficients = aCoefficients;
        }

        double[] getBCoefficients()
        {
            return _bCoefficients;
        }

        void setBCoefficients(final double[] bCoefficients)
        {

            int theLength = bCoefficients.length;

            for(int i = 0; i < theLength; i++)
            {
                _bCoefficients[i] = (float)bCoefficients[i];

            }
            //_bCoefficients = bCoefficients;
        }

        double[] getCCoefficients()
        {
            return _cCoefficients;
        }

        void setCCoefficients(final double[] cCoefficients)
        {
            int theLength = cCoefficients.length;

            for(int i = 0; i < theLength; i++)
            {
                _cCoefficients[i] = (float)cCoefficients[i];

            }
            //_cCoefficients = cCoefficients;
        }
    }

    public Coefficients createCoefficients()
    {
        return new Coefficients();
    }

    public Coefficients getCoefficients()
    {
        return _coefficients;
    }

    public void heatTransferSimulation(final double[] rightHandSideTs,
                                       final double[] soilTemperature,
                                       final double maximumSoilMoisture,
                                       final int numberOfSoilLayers,
                                       final double[] soilLayerDepths,
                                       final double airTemperature,
                                       final double tempAtBottomLayer,
                                       final double depthAtBottomLayer,
                                       final double psiat,
                                       final double modelTimeStepInSeconds,
                                       final double bParameter,
                                       final double snowDepth,
                                       final double snowDensity,
                                       final double snowCoverAsPercentage,
                                       final double soilType,
                                       final double quartz,
                                       final double maximumPorosity,
                                       final double iceEffectParameter)
    {
        // account for residue effect on conductivity
        double iceSummation = 0.0f;

        for(int i = 0; i < numberOfSoilLayers; i++)
        {
            iceSummation = iceSummation + _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i)
                - _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(i);
        }
        double maximumIceContent = _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(0)
            - _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(0);
 
        double maximumSoilThermalConductivity = SacSmaHtCommonMethods.calculateSoilThermalConductivity(soilType,
                                                                                               _sacHtData.getSacSmaHtState()
                                                                                                         .getSoilLayerUnfrozenWater(0),
                                                                                               maximumIceContent,
                                                                                               maximumPorosity,
                                                                                               0.);

        // CALCULATE SNOW/SOIL FLUX AND SOIL SURFACE TEMPERATURE IF SNOW
        double soilSurfaceTemperature = airTemperature;
        double weightedTemperature = -99.0f;

        if(snowDepth != 0.0f)
        {
            weightedTemperature = airTemperature;
            if(airTemperature > SacSmaHTConstants.ABSOLUTE_ZERO_IN_KELVINS)
            {
                weightedTemperature = snowCoverAsPercentage * SacSmaHTConstants.ABSOLUTE_ZERO_IN_KELVINS
                    + (1 - snowCoverAsPercentage) * airTemperature;
            }

            double snowThermalConductivity = SacSmaHtCommonMethods.calculateSnowThermalConductivity(snowDensity);

            // CALCULATION OF SOIL TEMPERATURE IS BASED ON Qsnow=Qsoil
            final double alp = 1.0f / (1.0f + maximumSoilThermalConductivity * snowDepth
                / (-snowThermalConductivity * 0.5f * soilLayerDepths[0]));
            soilSurfaceTemperature = alp * weightedTemperature + (1 - alp) * soilTemperature[0];
        }

        double sVariable = maximumSoilThermalConductivity * (soilTemperature[0] - soilSurfaceTemperature)
            / (0.5f * soilLayerDepths[0]);
        sVariable = Math.min(Math.max(sVariable, -100.f), 100.0f);

        //CALCULATE THE HEAT CAPACITY OF THE TOP SOIL LAYER
        double soilLayerHeatCapacity = _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(0)
            * SacSmaHTConstants.HEAT_CAPACITY_OF_WATER
            + (1.0f - maximumPorosity)
            * SacSmaHTConstants.HEAT_CAPACITY_OF_SOIL
            + (maximumPorosity - _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(0))
            * SacSmaHTConstants.HEAT_CAPACITY_OF_AIR
            + (_sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(0) - _sacHtData.getSacSmaHtState()
                                                                                        .getSoilLayerUnfrozenWater(0))
            * SacSmaHTConstants.HEAT_CAPACITY_OF_ICE;

        //CALCULATE THE MATRIX COEFFICIENTS AI, BI, AND CI FOR THE TOP LAYER
        double perAverageSoilDepth = -1 / (0.5f * soilLayerDepths[1]);

        final double[] aCoefficients = new double[SacSmaHTConstants.NSZ_ABC];
        final double[] bCoefficients = new double[SacSmaHTConstants.NSZ_ABC];
        final double[] cCoefficients = new double[SacSmaHTConstants.NSZ_ABC];

        aCoefficients[0] = 0.0f;
        cCoefficients[0] = ((float)maximumSoilThermalConductivity * (float)perAverageSoilDepth)
            / ((float)soilLayerDepths[0] * (float)soilLayerHeatCapacity);
        bCoefficients[0] = -cCoefficients[0];

        //CALCULATE THE VERTICAL SOIL TEMP GRADIENT BTWN THE TOP AND 2ND SOIL
        //LAYERS.  RECALC/ADJUST THE SOIL HEAT FLUX.  USE THE GRADIENT
        //AND FLUX TO CALC rightHandSideTs FOR THE TOP SOIL LAYER.

        double soilTemperatureGradient = ((float)soilTemperature[0] - (float)soilTemperature[1])
            / (-0.5f * (float)soilLayerDepths[1]);

        rightHandSideTs[0] = ((float)maximumSoilThermalConductivity * (float)soilTemperatureGradient - (float)sVariable)
            / ((float)soilLayerDepths[0] * (float)soilLayerHeatCapacity);

        //CALCULATE BOUNDARY LAYER TEMPERATURE USING LINEAR INTERPOLATION AND SINK/SOURCE TERM OF DIFFUSION EQUATION

        double boundaryLayerTemperature = SacSmaHtCommonMethods.calculateBoundaryLayerTemperature(soilTemperature[0],
                                                                                          soilTemperature[1],
                                                                                          soilLayerDepths,
                                                                                          depthAtBottomLayer,
                                                                                          0,
                                                                                          numberOfSoilLayers);

        double sinkSourceTerm = 0.0f;
        final CommonVariables unfrozenWater = new CommonVariables();
        unfrozenWater.val = (float)_sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(0);

        if(iceSummation != 0.0f || soilSurfaceTemperature < SacSmaHTConstants.ABSOLUTE_ZERO_IN_KELVINS)
        {
            sinkSourceTerm = SacSmaHtCommonMethods.snkSrc(soilSurfaceTemperature,
                                                  soilTemperature[0],
                                                  boundaryLayerTemperature,
                                                  _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(0),
                                                  unfrozenWater,
                                                  soilLayerHeatCapacity,
                                                  soilLayerDepths,
                                                  maximumPorosity,
                                                  psiat,
                                                  bParameter,
                                                  modelTimeStepInSeconds,
                                                  0,
                                                  soilType,
                                                  0.,
                                                  iceEffectParameter);
            _sacHtData.getSacSmaHtState().setSoilLayerUnfrozenWater(0, (float)unfrozenWater.val);

            rightHandSideTs[0] = (float)rightHandSideTs[0] - (float)sinkSourceTerm
                / ((float)soilLayerDepths[0] * (float)soilLayerHeatCapacity);

        }

        double perAverageSoilDepthForNthLayer = 0.0f;

        //LOOP THRU THE REMAINING SOIL LAYERS, REPEATING THE ABOVE PROCESS
        for(int i = 1; i < numberOfSoilLayers; i++)
        {

            //CALCULATE THIS SOIL LAYER'S HEAT CAPACITY
            soilLayerHeatCapacity = _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(i)
                * SacSmaHTConstants.HEAT_CAPACITY_OF_WATER
                + (1.0f - maximumSoilMoisture)
                * SacSmaHTConstants.HEAT_CAPACITY_OF_SOIL
                + (maximumSoilMoisture - _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i))
                * SacSmaHTConstants.HEAT_CAPACITY_OF_AIR
                + (_sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i) - _sacHtData.getSacSmaHtState()
                                                                                            .getSoilLayerUnfrozenWater(i))
                * SacSmaHTConstants.HEAT_CAPACITY_OF_ICE;
            double maximumSoilThermalConductivityForNthLayer;
            double boundaryLayerTemperatureForNthLayer;
            double soilTemperatureGradientForNthLayer;

            if(i != numberOfSoilLayers - 1)
            {
                //RETRIEVE THE THERMAL DIFFUSIVITY

                maximumIceContent = _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i)
                    - _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(i);
                maximumSoilThermalConductivityForNthLayer = SacSmaHtCommonMethods.calculateSoilThermalConductivity(soilType,
                                                                                                           _sacHtData.getSacSmaHtState()
                                                                                                                     .getSoilLayerUnfrozenWater(i),
                                                                                                           maximumIceContent,
                                                                                                           maximumSoilMoisture,
                                                                                                           quartz);

                //CALCULATE THE VERTICAL SOIL TEMP GRADIENT THRU THIS LAYER
                final double averageSoilLayerDepth = 0.5f * ((float)soilLayerDepths[i - 1] - (float)soilLayerDepths[i + 1]);
                soilTemperatureGradientForNthLayer = ((float)soilTemperature[i] - (float)soilTemperature[i + 1])
                    / (float)averageSoilLayerDepth;

                // can peraverageSoilDepth2 be 1/averageSoilDepth ** or at least use same form as peraveragesoildepth
                perAverageSoilDepthForNthLayer = 2.0f / (soilLayerDepths[i - 1] - soilLayerDepths[i + 1]);
                cCoefficients[i] = -(float)maximumSoilThermalConductivityForNthLayer
                    * (float)perAverageSoilDepthForNthLayer
                    / (((float)soilLayerDepths[i - 1] - (float)soilLayerDepths[i]) * (float)soilLayerHeatCapacity);

                //CALCULATE LAYER BOUNDARY TEMPERATURE
                boundaryLayerTemperatureForNthLayer = SacSmaHtCommonMethods.calculateBoundaryLayerTemperature(soilTemperature[i],
                                                                                                      soilTemperature[i + 1],
                                                                                                      soilLayerDepths,
                                                                                                      depthAtBottomLayer,
                                                                                                      i,
                                                                                                      numberOfSoilLayers);
            }
            else
            {

                //RETRIEVE THE THERMAL DIFFUSIVITY FOR THE LOWEST SOIL LAYER
                maximumIceContent = _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i)
                    - _sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(i);
                maximumSoilThermalConductivityForNthLayer = SacSmaHtCommonMethods.calculateSoilThermalConductivity(soilType,
                                                                                                           _sacHtData.getSacSmaHtState()
                                                                                                                     .getSoilLayerUnfrozenWater(i),
                                                                                                           maximumIceContent,
                                                                                                           maximumSoilMoisture,
                                                                                                           quartz);
                boundaryLayerTemperatureForNthLayer = SacSmaHtCommonMethods.calculateBoundaryLayerTemperature(soilTemperature[i],
                                                                                                      tempAtBottomLayer,
                                                                                                      soilLayerDepths,
                                                                                                      depthAtBottomLayer,
                                                                                                      i,
                                                                                                      numberOfSoilLayers);

                //CALCULATE THE VERTICAL SOIL TEMP GRADIENT THRU THE LOWEST LAYER
                soilTemperatureGradientForNthLayer = ((float)soilTemperature[i] - (float)tempAtBottomLayer)
                    / (0.5f * ((float)soilLayerDepths[i - 1] + (float)soilLayerDepths[i]) - (float)depthAtBottomLayer);

                cCoefficients[i] = 0.0f;
            }

            //CALCULATE rightHandSideTs FOR THIS LAYER AFTER CALCULATING A PARTIAL PRODUCT
            final double denominatorTerm = (soilLayerDepths[i] - soilLayerDepths[i - 1]) * soilLayerHeatCapacity;
            rightHandSideTs[i] = ((float)maximumSoilThermalConductivityForNthLayer
                * (float)soilTemperatureGradientForNthLayer - (float)maximumSoilThermalConductivity
                * (float)soilTemperatureGradient)
                / (float)denominatorTerm;

            //CALCULATE SINK/SOURCE TERM OF DIFFUSION EQUATION
            if(iceSummation != 0.0f || boundaryLayerTemperature < SacSmaHTConstants.ABSOLUTE_ZERO_IN_KELVINS)
            {
                unfrozenWater.val = (float)_sacHtData.getSacSmaHtState().getSoilLayerUnfrozenWater(i);
                sinkSourceTerm = SacSmaHtCommonMethods.snkSrc(boundaryLayerTemperature,
                                                      soilTemperature[i],
                                                      boundaryLayerTemperatureForNthLayer,
                                                      _sacHtData.getSacSmaHtState().getSoilLayerMoistureContent(i),
                                                      unfrozenWater,
                                                      soilLayerHeatCapacity,
                                                      soilLayerDepths,
                                                      maximumSoilMoisture,
                                                      psiat,
                                                      bParameter,
                                                      modelTimeStepInSeconds,
                                                      i,
                                                      soilType,
                                                      quartz,
                                                      iceEffectParameter);
                _sacHtData.getSacSmaHtState().setSoilLayerUnfrozenWater(i, (float)unfrozenWater.val);
                rightHandSideTs[i] = (float)rightHandSideTs[i] - ((float)sinkSourceTerm / (float)denominatorTerm);
            }

            aCoefficients[i] = -(float)maximumSoilThermalConductivity * (float)perAverageSoilDepth
                / (((float)soilLayerDepths[i - 1] - (float)soilLayerDepths[i]) * (float)soilLayerHeatCapacity);
            bCoefficients[i] = -(aCoefficients[i] + cCoefficients[i]);

            //RESET VALUES OF maximumSoilThermalConductivity, soilTemperatureGradient, AND perAverageSoilDepth FOR LOOP TO NEXT SOIL LYR
            boundaryLayerTemperature = boundaryLayerTemperatureForNthLayer;
            maximumSoilThermalConductivity = maximumSoilThermalConductivityForNthLayer;
            soilTemperatureGradient = soilTemperatureGradientForNthLayer;
            perAverageSoilDepth = perAverageSoilDepthForNthLayer;
        }

        _coefficients.setACoefficients(aCoefficients);
        _coefficients.setBCoefficients(bCoefficients);
        _coefficients.setCCoefficients(cCoefficients);

    }

    //! ----------------------------------------------------------------------         
    //! CREATE FINITE DIFFERENCE VALUES FOR USE IN ROSR12 ROUTINE                      
    //! ----------------------------------------------------------------------   
    public double[] hstep(final double[] inputSoilTemperature,
                          final double[] rightHandSideTs,
                          final double timeStepInSeconds,
                          final int numberOfSoilLayers)
    {
        double[] triDiagonalSolution = new double[SacSmaHTConstants.NSZ_ABC];
        final double[] aCoefficients = _coefficients.getACoefficients();
        final double[] bCoefficients = _coefficients.getBCoefficients();
        final double[] cCoefficients = _coefficients.getCCoefficients();

        for(int i = 0; i < numberOfSoilLayers; i++)
        {
            rightHandSideTs[i] = (float)rightHandSideTs[i] * (float)timeStepInSeconds;
            aCoefficients[i] = (float)aCoefficients[i] * (float)timeStepInSeconds;
            bCoefficients[i] = 1.0f + (float)bCoefficients[i] * (float)timeStepInSeconds;
            cCoefficients[i] = (float)cCoefficients[i] * (float)timeStepInSeconds;
        }

        _coefficients.setACoefficients(aCoefficients);
        _coefficients.setBCoefficients(bCoefficients);
        _coefficients.setCCoefficients(cCoefficients);

        triDiagonalSolution = rosr12(rightHandSideTs, rightHandSideTs, numberOfSoilLayers);

        double[] outputSoilTemperature = new double[numberOfSoilLayers];

        for(int i = 0; i < numberOfSoilLayers; i++)
        {
            outputSoilTemperature[i] = (float)inputSoilTemperature[i] + (float)triDiagonalSolution[i];
        }
        return outputSoilTemperature;
    }

    public double[] rosr12(final double[] d, final double[] delta, final int numberOfSoilLayers)
    {
        //rosr12 is a routine to solve the tri-diagonal matrix

        final double[] aCoefficients = _coefficients.getACoefficients();
        final double[] bCoefficients = _coefficients.getBCoefficients();
        final double[] cCoefficients = _coefficients.getCCoefficients();
        final double[] matrixSolution = new double[numberOfSoilLayers];
        cCoefficients[numberOfSoilLayers - 1] = 0.0f;

        /*
         * for (int i=0; i<numberOfSoilLayers; i++) { System.out.println(i + " a "+ aCoefficients[i] + " b
         * "+bCoefficients[i]+ " c "+cCoefficients[i] + " d "+d[i]); }
         */

        //solve coefficients for 1st soil layer
        matrixSolution[0] = -(float)cCoefficients[0] / (float)bCoefficients[0];
        delta[0] = (float)d[0] / (float)bCoefficients[0];

        for(int i = 1; i < numberOfSoilLayers; i++)
        {
            matrixSolution[i] = -(float)cCoefficients[i]
                * (1.0f / ((float)bCoefficients[i] + (float)aCoefficients[i] * (float)matrixSolution[i - 1]));
            delta[i] = ((float)d[i] - (float)aCoefficients[i] * (float)delta[i - 1])
                * (1.0f / ((float)bCoefficients[i] + (float)aCoefficients[i] * (float)matrixSolution[i - 1]));
        }

        //set answer to delta for lowest soil layer
        matrixSolution[numberOfSoilLayers - 1] = (float)delta[numberOfSoilLayers - 1];
        //adjust answer for soil layers 2 through numberOfSoilLayers
        for(int i = 1; i < numberOfSoilLayers; i++)
        {
            final int ii = (numberOfSoilLayers - 1) - i;
            matrixSolution[ii] = (float)matrixSolution[ii] * (float)matrixSolution[ii + 1] + (float)delta[ii];
        }
        // Values never get update in this method, why we set them again? 
        // except cCoefficients
        _coefficients.setACoefficients(aCoefficients);
        _coefficients.setBCoefficients(bCoefficients);
        _coefficients.setCCoefficients(cCoefficients);

        return matrixSolution;
    }

}
