package ohd.hseb.ohdmodels.sacsmaHT;

import ohd.hseb.util.fews.DataType;

final public class SacSmaHTConstants
{
    private SacSmaHTConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    public final static double ONE_HALF_HOUR_IN_SECONDS = 1800;
    public final static int NSZ_ABC = 10;
    public final static double ABSOLUTE_ZERO_IN_KELVINS = 273.16;
    // gravity constant in kg*m**3/s
    public final static double GRAVITY_CONSTANT = 9.81;
    // heat capacity units are Joules/Gram*Kelvin
    public final static double HEAT_CAPACITY_OF_WATER = 4.2E6;
    public final static double HEAT_CAPACITY_OF_AIR = 1004.0;
    public final static double HEAT_CAPACITY_OF_SOIL = 1.26E6;
    public final static double HEAT_CAPACITY_OF_ICE = 2.106E6;
    // conductivity units are Watts/Meter*Kelvin
    public final static double WATER_CONDUCTIVITY = 0.57;
    public final static double QUARTZ_CONDUCTIVITY = 7.7;
    public final static double ICE_CONDUCTIVITY = 2.2;
    // density units are kg/m**3
    public final static double DENSITY_OF_ICE = 920.0;
    public final static double DENSITY_OF_WATER = 1000.0;
    public final static double SICEMN = 0.01;

    /** TO CALCULATE SOIL TEMPERATURE & ICE CONTENT * */

    public final static int MAX_NUMBER_OF_USER_DEFINED_PROFILES = 8;
    public final static int MAX_NUMBER_OF_SOIL_LAYERS = 8;
    public static double DEPTH_AT_BOTTOM_LAYER_IN_METERS = -2.5;

    // UPPER_ZONE_TENSION_UNFROZEN_WATER - UZTWH
    public final static String UZTWH_TAG = "UPPER_ZONE_TENSION_UNFROZEN_WATER";
    // UPPER_ZONE_FREE_UNFROZEN_WATER - UZFWH
    public final static String UZFWH_TAG = "UPPER_ZONE_FREE_UNFROZEN_WATER";
    // LOWER_ZONE_TENSION_UNFROZEN_WATER - LZTWH
    public final static String LZTWH_TAG = "LOWER_ZONE_TENSION_UNFROZEN_WATER";
    // LOWER_ZONE_FREE_SECONDARY_UNFROZEN_WATER - LZFSH
    public final static String LZFSH_TAG = "LOWER_ZONE_FREE_SECONDARY_UNFROZEN_WATER";
    // LOWER_ZONE_FREE_PRIMARY_UNFROZEN_WATER - LZFPH
    public final static String LZFPH_TAG = "LOWER_ZONE_FREE_PRIMARY_UNFROZEN_WATER";
    public final static String INIT_SNOW_WATER_EQUIVALENT_TAG = "INIT_SNOW_WATER_EQUIVALENT";
    public final static String INIT_AIR_TEMPERATURE_TAG = "INIT_AIR_TEMPERATURE";
    public final static String INIT_SNOW_DEPTH_TAG = "INIT_SNOW_DEPTH";
    public final static String LAYER_DEPTH_TAG = "DEPTH_TO_BOTTOM_OF_LAYER";
    // SOILLAYER_MOISTURE_CONTENT_SMC - SSM
    public final static String SOIL_LAYER_MOISTURE_CONTENT_TAG = "SOILLAYER_MOISTURE_CONTENT_SMC";
    // Used for time series to keep the short name.
    public final static String SOIL_LAYER_MOISTURE_CONTENT_TS_TAG = "SSM";
    // SOILLAYER_UNFROZEN_WATER_SH2O - WSOIL
    public final static String SOIL_LAYER_WATER_CONTENT_TAG = "SOILLAYER_UNFROZEN_WATER_SH2O";
    // SOILLAYER_TEMPERATURE_TSOIL - SST
    public final static String SOIL_LAYER_TEMPERATURE_TAG = "SOILLAYER_TEMPERATURE_TSOIL";
    // Used for time series to keep the short name
    public final static String SOIL_LAYER_TEMPERATURE_TS_TAG = "SST";

    public final static String NUMBER_SOIL_LAYER_TAG = "NUMBER_SOIL_LAYER";

    /*
     * Based on Victor's change 6/15 - frozen ground parameters for which science to calibrate doesn't exist
     */
    public final static double MAX_SOIL_POROSITY = .58; // rsmax
    public final static double CRITICAL_ICE_CONTENT = -1.; // crfrz
    public final static double GAMMA_DISTRIBUTION_PARAMETER = 6.; // cvfrz

    public final static String SOIL_MOISTURE_ZONE_CONTENTS = "SMZC";
    public static final String UPPER_ZONE_TENSION_WATER_CONTENTS = "UPPER_ZONE_TENSION_WATER_CONTENTS_UZTWC";
    public static final String UPPER_ZONE_FREE_WATER_CONTENTS = "UPPER_ZONE_FREE_WATER_CONTENTS_UZFWC";
    public static final String LOWER_ZONE_TENSION_WATER_CONTENTS = "LOWER_ZONE_TENSION_WATER_CONTENTS_LZTWC";
    public static final String LOWER_ZONE_FREE_PRIMARY_WATER_CONTENTS = "LOWER_ZONE_FREE_PRIMARY_WATER_CONTENTS_LZFPC";
    public static final String LOWER_ZONE_FREE_SECONDARY_WATER_CONTENTS = "LOWER_ZONE_FREE_SECONDARY_WATER_CONTENTS_LZFSC";
    public static final String ADDITIONAL_IMPERVIOUS_WATER_CONTENTS = "ADDITIONAL_IMPERVIOUS_AREA_TENSION_WATER_CONTENTS_ADIMC";
    public static final String UPPER_ZONE_TENSION_WATER_DEFICIT = "UZTDEF";
    public static final String LOWER_ZONE_TENSION_WATER_DEFICIT = "LZTDEF";
    public static final String SOIL_TEMPERATURE_AT_LAYER = "TEMP-AT-LAYER";
    public static final String TOTAL_SOIL_MOISTURE_AT_LAYER = "T-MOISTURE-AT-LAYER";
    public static final String TOTAL_SOIL_MOISTURE_AS_PERCENT_AT_LAYER = "T-MOISTURE-AS-PERCENT-AT-LAYER";

    public static final String DEFAULT_OPERATION_NAME = "Default";
    public static final String COLD_START_STATE_NAME = "ColdStart";

    // Run modes
    public static final String FULL_RUN_STR = "SOIL_AND_HEAT_TRANSFER";
    public static final String ONLY_SOIL_RUN_STR = "ONLY_SOIL";
    public static final String FULL_RUN_UNAFFECTED_RUNOFF_STR = "SOIL_AND_HEAT_TRANSFER_UNAFFECTED_RUNOFF";
    public static final String[] LIST_OF_RUN_MODES = new String[]{FULL_RUN_STR, ONLY_SOIL_RUN_STR,
        FULL_RUN_UNAFFECTED_RUNOFF_STR};

    public static final double FRST_FACT = 5.0;

    final static String[] REQUESTED_OUTPUT_TIMESERIES_TYPES = {DataType.CHANNEL_INFLOW_DATATYPE,
        DataType.FROZEN_DEPTH_DATATYPE, DataType.FGIX_DATATYPE};

}
