package ohd.hseb.ohdmodels.sacsmaHT;

import ohd.hseb.util.Logger;

/**
 * @author FewsPilot Team
 */
final class SacSmaHTData
{

    // The following is assigned in execute, so if needs to be used before that 
    // need to send in to the constructor...
    private SacSmaHTModelParameters _sacSmaHtParameters;
    private SacSmaHTModelParameters _sacSmaHtSavedParameters;
    private SacSmaHTModelState _sacSmaHtState;
    private Logger _logger;
    private FrdStfg _frdStfg;
    private boolean _isColdStart = true;
    private double _runoff;
    private double _frzdInCm;
    private double _imperviousRunoff;
    private double _directrunoff;
    private double _surfaceRunoff;
    private double _interflow;
    private double _primaryBaseFlow;
    private double _secondarybaseFlow;
    private double[] _interpolatedSoilTemperature;
    private double[] _interpolatedTotalSoilMoisture;
    private double[] _interpolatedUnfrozenSoilMoisture;
    private double[] _interpolatedTotalSoilMoistureAsPercent;

    class FrdStfg
    {
        double maximumSoilMoisture;
        double psisat;
        double brt;
        double soilWiltingPoint;
        double quartz;
        double soilType;
        int nUpl;
        int nsac;
        double rTuz;
        double rTlz;
        double dzUp;
        double dzLow;

        FrdStfg()
        {
        };

        FrdStfg(final double sMax,
                final double psisat,
                final double brt,
                final double soilWiltingPoint,
                final double quartz,
                final double soilType,
                final int nUpl,
                final int nsac,
                final double rTuz,
                final double rTlz,
                final double dzUp,
                final double dzLow)
        {
            this.maximumSoilMoisture = sMax;
            this.psisat = psisat;
            this.brt = brt;
            this.soilWiltingPoint = soilWiltingPoint;
            this.quartz = quartz;
            this.soilType = soilType;
            this.nUpl = nUpl;
            this.nsac = nsac;
            this.rTuz = rTuz;
            this.rTlz = rTlz;
            this.dzUp = dzUp;
            this.dzLow = dzLow;
        }

        double getmaximumSoilMoisture()
        {
            return maximumSoilMoisture;
        };

        double getpsisat()
        {
            return psisat;
        };

        double getbrt()
        {
            return brt;
        };

        double getsoilWiltingPoint()
        {
            return soilWiltingPoint;
        };

        double getquartz()
        {
            return quartz;
        };

        double getsoilType()
        {
            return soilType;
        };

        int getnUpl()
        {
            return nUpl;
        };

        int getnsac()
        {
            return nsac;
        };

        double getrTuz()
        {
            return rTuz;
        };

        double getrTlz()
        {
            return rTlz;
        };

        double getdzUp()
        {
            return dzUp;
        };

        double getdzLow()
        {
            return dzLow;
        };
    }

    public void createFrdStfg(final double sMax,
                              final double psisat,
                              final double brt,
                              final double swlt,
                              final double quartz,
                              final double stype,
                              final int nUpl,
                              final int nsac,
                              final double rTuz,
                              final double rTlz,
                              final double dzUp,
                              final double dzLow)
    {

        _frdStfg = new FrdStfg(sMax, psisat, brt, swlt, quartz, stype, nUpl, nsac, rTuz, rTlz, dzUp, dzLow);
    }

    public SacSmaHTData()
    {
        _frdStfg = new FrdStfg();
    }

    public FrdStfg getFrdStfg()
    {
        return _frdStfg;
    }

    public void setFrdStfg(final FrdStfg stfg)
    {
        _frdStfg = stfg;
    }

    public Logger getLogger()
    {
        return _logger;
    }

    public void setLogger(final Logger _logger)
    {
        this._logger = _logger;
    }

    public SacSmaHTModelParameters getSacSmaHtParameters()
    {
        return _sacSmaHtParameters;
    }

    public SacSmaHTModelParameters getSacSmaHtSavedParameters()
    {
        return _sacSmaHtSavedParameters;
    }

    public void setSacSmaHtParameters(final SacSmaHTModelParameters smaHtParameters)
    {
        _sacSmaHtParameters = smaHtParameters;
    }

    public void setSacSmaHtSavedParameters(final SacSmaHTModelParameters smaHtSavedParameters)
    {
        _sacSmaHtSavedParameters = smaHtSavedParameters;
    }

    public SacSmaHTModelState getSacSmaHtState()
    {
        return _sacSmaHtState;
    }

    public void setSacSmaHtState(SacSmaHTModelState smaHtState)
    {
        _sacSmaHtState = smaHtState;
    }

    public boolean isColdStart()
    {
        return _isColdStart;
    }

    public void setColdStart(final boolean isColdStart)
    {
        _isColdStart = isColdStart;
    }

    public void setChannelInflow(final double runoff)
    {
        _runoff = runoff;
    }

    public double getChannelInflow()
    {
        return _runoff;
    }

    public double getFrozenDepth()
    {
        return _frzdInCm;
    }

    public void setFrozenDepth(final double frzdInCm)
    {
        _frzdInCm = frzdInCm;

    }

    public void setRunoffComponents(final double imperviousRunoff,
                                    final double directrunoff,
                                    final double surfaceRunoff,
                                    final double interflow,
                                    final double primaryBaseFlow,
                                    final double secondarybaseFlow)
    {
        _imperviousRunoff = imperviousRunoff;
        _directrunoff = directrunoff;
        _surfaceRunoff = surfaceRunoff;
        _interflow = interflow;
        _primaryBaseFlow = primaryBaseFlow;
        _secondarybaseFlow = secondarybaseFlow;
    }

    public double[] getRunoffComponents()
    {
        return new double[]{_imperviousRunoff, _directrunoff, _surfaceRunoff, _interflow, _primaryBaseFlow,
            _secondarybaseFlow};
    }

    public void setInterpolatedSoilTemperature(final double[] interpolatedSoilTemperature)
    {
        _interpolatedSoilTemperature = interpolatedSoilTemperature;
    }

    public void setInterpolatedTotalSoilMoisture(final double[] interpolatedTotalSoilMoisture)
    {
        _interpolatedTotalSoilMoisture = interpolatedTotalSoilMoisture;
    }

    public void setInterpolatedTotalSoilMoistureAsPercent(final double[] interpolatedTotalSoilMoistureAsPercent)
    {
        _interpolatedTotalSoilMoistureAsPercent = interpolatedTotalSoilMoistureAsPercent;

    }

    public void setInterpolatedUnfrozenSoilMoisture(final double[] interpolatedUnfrozenSoilMoisture)
    {
        _interpolatedUnfrozenSoilMoisture = interpolatedUnfrozenSoilMoisture;
    }

    public double[] getInterpolatedSoilTemperatures()
    {
        return _interpolatedSoilTemperature;
    }

    public double[] getInterpolatedTotalSoilMoisture()
    {
        return _interpolatedTotalSoilMoisture;
    }

    public double[] getInterpolatedTotalSoilMoistureAsPercent()
    {
        return _interpolatedTotalSoilMoistureAsPercent;
    }

    public double[] getUnfrozenSoilMoisture()
    {
        return _interpolatedUnfrozenSoilMoisture;
    }

}
