package ohd.hseb.ohdmodels.sacsmaHT;

import java.util.List;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

final public class SacSmaHTModelLegacyModelDriver extends ModelDriver
{

    private static final String SACSMAHT_EXE_NAME = "sacsmaht";

    public SacSmaHTModelLegacyModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new SacSmaHTModelLegacyModelState();
        _parameters = new SacSmaHTModelLegacyModelParameters();
        _savedParameters = new SacSmaHTModelLegacyModelParameters();
    }

    @Override
    public SacSmaHTModelLegacyModelParameters getParameters()
    {
        return (SacSmaHTModelLegacyModelParameters)_parameters;
    }

    @Override
    public SacSmaHTModelLegacyModelParameters getPreviousParameters()
    {
        return (SacSmaHTModelLegacyModelParameters)_savedParameters;
    }

    //Original method should be uncommented when  Step 2 is ready. and remove the next execute() 

    @Override
    public void execute() throws Exception
    {
        // All input time series have the same time step.  Any time series is a driver.
        _drivingTs = _tsList.get(0);

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        //Send in work dir and state dir
        final LegacyModelAdapter sacsmaHTAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        sacsmaHTAdapter.writeStandAloneFiles();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument
        sacsmaHTAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + SACSMAHT_EXE_NAME, null);

        getState().loadState(sacsmaHTAdapter.getOutputStateFileName(), _logger);
        getState().setDateTime(getComputationEndTime());

        //load the results
        final List<RegularTimeSeries> resultsList = sacsmaHTAdapter.readOutputFlatFilesToLists();

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }
    }
}
