/**
 * 
 */
package ohd.hseb.ohdmodels.sacsmaHT;

import java.util.HashMap;

import ohd.hseb.util.fews.DataType;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.RUNOFF_COMPONENT;

/**
 * @author FewsPilot Team
 */
final class SacSmaHTResults extends HashMap<String, Double>
{

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * No-arg constructor just to initialize certain values to MISSING_VALUE so that if the user picks results that are
     * not relevant to that particular mode (ONLY_SOIL in particular), he will get MISSING_VALUES values
     */

    public SacSmaHTResults()
    {
        put(DataType.FROZEN_DEPTH_DATATYPE, OHDConstants.MISSING_DATA);
        put(DataType.FGIX_DATATYPE, OHDConstants.MISSING_DATA);
    }

    public void setResults(final SacSmaHTData data)
    {
        put(DataType.CHANNEL_INFLOW_DATATYPE, data.getChannelInflow());
        put(DataType.FROZEN_DEPTH_DATATYPE, data.getFrozenDepth());
        put(DataType.FGIX_DATATYPE, data.getSacSmaHtState().getFindex());

        //for soil temperatures
        final double[] interpolatedSoilTemperatures = data.getInterpolatedSoilTemperatures();
        for(int i = 0; i < SacSmaHTConstants.MAX_NUMBER_OF_USER_DEFINED_PROFILES; i++)
        {
            //the null test takes care of the case where only soil was requested as
            //interpolatedSoilTemperateures were not calculated in that case.
            if((interpolatedSoilTemperatures != null) && (i < interpolatedSoilTemperatures.length))
            {
                put(SacSmaHTConstants.SOIL_TEMPERATURE_AT_LAYER + i, interpolatedSoilTemperatures[i]);
            }
            else
            {
                put(SacSmaHTConstants.SOIL_TEMPERATURE_AT_LAYER + i, OHDConstants.MISSING_DATA);
            }
        }

        //		for total soil moisture
        final double[] interpolatedTotalSoilMoisture = data.getInterpolatedTotalSoilMoisture();
        for(int i = 0; i < SacSmaHTConstants.MAX_NUMBER_OF_USER_DEFINED_PROFILES; i++)
        {
            if(i < interpolatedTotalSoilMoisture.length)
            {
                put(SacSmaHTConstants.TOTAL_SOIL_MOISTURE_AT_LAYER + i, interpolatedTotalSoilMoisture[i]);
            }
            else
            {
                put(SacSmaHTConstants.TOTAL_SOIL_MOISTURE_AT_LAYER + i, OHDConstants.MISSING_DATA);
            }
        }

        //		for total soil moisture as percent
        final double[] interpolatedTotalSoilMoistureAsPercent = data.getInterpolatedTotalSoilMoistureAsPercent();
        for(int i = 0; i < SacSmaHTConstants.MAX_NUMBER_OF_USER_DEFINED_PROFILES; i++)
        {
            if(i < interpolatedTotalSoilMoistureAsPercent.length)
            {
                put(SacSmaHTConstants.TOTAL_SOIL_MOISTURE_AS_PERCENT_AT_LAYER + i,
                    interpolatedTotalSoilMoistureAsPercent[i]);
            }
            else
            {
                put(SacSmaHTConstants.TOTAL_SOIL_MOISTURE_AS_PERCENT_AT_LAYER + i, OHDConstants.MISSING_DATA);
            }
        }

        //for sac storages
        put(SacSmaHTConstants.UPPER_ZONE_TENSION_WATER_CONTENTS, data.getSacSmaHtState().getUztwc());
        put(SacSmaHTConstants.UPPER_ZONE_FREE_WATER_CONTENTS, data.getSacSmaHtState().getUzfwc());
        put(SacSmaHTConstants.LOWER_ZONE_TENSION_WATER_CONTENTS, data.getSacSmaHtState().getLztwc());
        put(SacSmaHTConstants.LOWER_ZONE_FREE_PRIMARY_WATER_CONTENTS, data.getSacSmaHtState().getLzfpc());
        put(SacSmaHTConstants.LOWER_ZONE_FREE_SECONDARY_WATER_CONTENTS, data.getSacSmaHtState().getLzfsc());
        put(SacSmaHTConstants.ADDITIONAL_IMPERVIOUS_WATER_CONTENTS, data.getSacSmaHtState().getAdimc());
        put(SacSmaHTConstants.UPPER_ZONE_TENSION_WATER_DEFICIT, data.getSacSmaHtParameters().getUztwm()
            - data.getSacSmaHtState().getUztwc());
        put(SacSmaHTConstants.LOWER_ZONE_TENSION_WATER_DEFICIT, data.getSacSmaHtParameters().getLztwm()
            - data.getSacSmaHtState().getLztwc());

        //for runoff components
        put(RUNOFF_COMPONENT.IMP.getTypeName(), data.getRunoffComponents()[0]);
        put(RUNOFF_COMPONENT.DIR.getTypeName(), data.getRunoffComponents()[1]);
        put(RUNOFF_COMPONENT.SUR.getTypeName(), data.getRunoffComponents()[2]);
        put(RUNOFF_COMPONENT.INT.getTypeName(), data.getRunoffComponents()[3]);
        put(RUNOFF_COMPONENT.PRI.getTypeName(), data.getRunoffComponents()[4]);
        put(RUNOFF_COMPONENT.SUP.getTypeName(), data.getRunoffComponents()[5]);

    }
}
