package ohd.hseb.ohdmodels.sarroute;

import java.util.List;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.State;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

final public class SarrouteModelDriver extends ModelDriver
{

    private static final String SARROUTE_EXE_NAME = "sarroute";

    public SarrouteModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new SarrouteModelState();
        _parameters = new SarrouteModelParameters();
        _savedParameters = new SarrouteModelParameters();
    }

    @Override
    public SarrouteModelParameters getParameters()
    {
        return (SarrouteModelParameters)_parameters;
    }

    @Override
    public SarrouteModelState getState()
    {
        return (SarrouteModelState)_state;
    }

    @Override
    public SarrouteModelParameters getPreviousParameters()
    {
        return (SarrouteModelParameters)_savedParameters;
    }

    @Override
    public void execute() throws Exception
    {
        // All input time series have the same time step.  Any time series is a driver.
        _drivingTs = _tsList.get(0);

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        //Send in work dir and state dir
        final LegacyModelAdapter sarrouteAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        sarrouteAdapter.writeStandAloneFiles();

        //Clear out state Map before storing the new data (bug 244)
        ((State)_state).getStateMap().clear();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument
        sarrouteAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + SARROUTE_EXE_NAME, null);

        getState().loadState(sarrouteAdapter.getOutputStateFileName(), _logger);
        getState().setDateTime(getComputationEndTime());

        //load the results
        final List<RegularTimeSeries> resultsList = sarrouteAdapter.readOutputFlatFilesToLists();

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }

    }

}
