package ohd.hseb.ohdmodels.snow17;

/**
 * Overrides the precipitation at this time step to RAIN or SNOW, so it is not determined by the temperature index.
 */
public enum RAINSNOW_MOD_VALUE
{
    NO_MOD, RAIN, SNOW;

    /**
     * convert a double to the MOD: 1.0 is RAIN, 2.0 is SNOW, anything else(including 0.0 or -999.0) is NO_MOD
     */
    public static RAINSNOW_MOD_VALUE getModFromValue(final double dValue)
    {
        RAINSNOW_MOD_VALUE mod = NO_MOD;

        if(dValue == Snow17ModelConstants.RAINSNOW_MOD_R)
        {
            mod = RAIN;
        }
        else if(dValue == Snow17ModelConstants.RAINSNOW_MOD_S)
        {
            mod = SNOW;
        }

        return mod;
    }
} //close public enum RAINSNOW_MOD_VALUE
