package ohd.hseb.ohdmodels.snow17;

import ohd.hseb.util.fews.DataType;

public enum SNOW17_MODS
{
    /*
     * Total 6 MODS: 3 MODS(AESCCHNG, WEADD and WECHNG) are affected by LSTCMPDY, 3 MODS(MFC, UADJ and RAINSNOW) are
     * not.
     */
    AESCCHNG(DataType.AESCCHNG_DATATYPE, true), //
    MFC(DataType.MFC_DATATYPE, false), //
    RAINSNOW(DataType.RAINSNOW_DATATYPE, false), //
    UADJ(DataType.UADJ_DATATYPE, false), //
    WEADD(DataType.WEADD_DATATYPE, true), //
    WECHNG(DataType.WECHNG_DATATYPE, true);

    final private String _dataType; //will not be changed
    final private boolean _dependOnLstcmpdy; //will not be changed

    private SNOW17_MODS(final String dataType, final boolean dependOnLstcmpdy)
    {
        _dataType = dataType;
        _dependOnLstcmpdy = dependOnLstcmpdy;
    }

    public String getDataType()
    {
        return _dataType;
    }

    public boolean dependOnLstcmpdy()
    {
        return _dependOnLstcmpdy;
    }

}
