package ohd.hseb.ohdmodels.snow17;

import ohd.hseb.util.fews.OHDConstants;

final public class Snow17ModelConstants
{
    private Snow17ModelConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    /** PRINTSNW is a TECHNIQUE for Snow17 to print out the table like message */
    public static final String PRINTSNW = "PRINTSNW";

    /** SNOW */
    public static final String TECHNIQUE_SNOW = "SNOW";

    /** UPSC */
    public static final String TECHNIQUE_UPSC = "UPSC";

    /** UPWE */
    public static final String TECHNIQUE_UPWE = "UPWE";

    /** "PRECIP_IS_ALL_RAIN" */
    public static final String PRECIP_IS_ALL_RAIN = "PRECIP_IS_ALL_RAIN";

    /**
     * "SACSNOW" is a TECHNIQUE in NWSRFS for the models Snow17 and SacSma. In NWSRFS, it has the the value TRUE or
     * FALSE(default). If TRUE, output the state TS(NWSRFS). Here, in CHPS models, if TRUE, SacSma and Snow17 will not
     * only output state TS, but also the secondary TSs.
     */
    public static final String SACSNOW_FULL_VERSION = "SACSNOW";

    /** SNOW17 RAINSNOW MOD CONSTANT, 1(RAIN) */
    public final static int RAINSNOW_MOD_R = 1;

    /** SNOW17 RAINSNOW MOD CONSTANT, 2(SNOW) */
    public final static int RAINSNOW_MOD_S = 2;

    /** If snow fall in each hour is less than 0.2 (e.g. if(sfall < 0.2 * _itpx))-- DO NOT LEAVE CURRENT DEPLETION CURVE */
    final static double HSNOF = 0.2;

    public static final String[] SNOW17_STATE_NAMES = new String[]{ // 14 variables
    Snow17ModelState.WE_TAG, //
        Snow17ModelState.NEGHS_TAG, //
        Snow17ModelState.LIQW_TAG, //
        Snow17ModelState.TINDEX_TAG, //
        Snow17ModelState.ACCMAX_TAG, //
        Snow17ModelState.SNDPT_TAG, //
        Snow17ModelState.SNTMP_TAG, //
        Snow17ModelState.TAPREV_TAG, //
        Snow17ModelState.SB_TAG, //
        Snow17ModelState.SBAESC_TAG, //
        Snow17ModelState.SBWS_TAG, //
        Snow17ModelState.STORGE_TAG, //
        Snow17ModelState.AEADJ_TAG, //
        OHDConstants.EXLAGARRAY_TAG};

    public static final String[] SNOW17_PARAM_NAMES = new String[]{// 17 variables
    Snow17ModelParameters.MV_TAG,//
        Snow17ModelParameters.MBASE_TAG, //
        Snow17ModelParameters.TAELEV_TAG, //
        Snow17ModelParameters.ELEV_TAG, //
        Snow17ModelParameters.TIPM_TAG, //
        Snow17ModelParameters.SCF_TAG, //
        Snow17ModelParameters.PXTEMP_TAG, //
        Snow17ModelParameters.SI_TAG, //
        Snow17ModelParameters.PXADJ_TAG, //
        Snow17ModelParameters.UADJ_TAG, //
        Snow17ModelParameters.MFMIN_TAG, //
        Snow17ModelParameters.MFMAX_TAG, //
        Snow17ModelParameters.NMF_TAG, //
        Snow17ModelParameters.ALAT_TAG, //
        Snow17ModelParameters.PLWHC_TAG, //
        Snow17ModelParameters.DAYGM_TAG, //
        OHDConstants.ADC_TAG}; //ADC is a double array, stored as a string separated by space in netcdf file
}
