package ohd.hseb.ohdmodels.snow17;

/**
 * This immutable class object holds all the data returned by
 * {@link Snow17Model#pack19(double, double[], double[], double, long, double, double, double, int)} for each time step
 * of MAT input time series (air temperature). raim is an double array. If MAP(precip time series) interval equals to
 * MAT, raim array size is 1. If MAP interval is half of MAT(e.g. MAP interval ITPX = 3hr, MAT interval IDT = 6hr), raim
 * array size is 2. Other data(e.g. swe, sasc, snsg etc) are single double values.
 */
final public class Snow17Results
{

    private final double[] _raim; //array length == _snow17ModelParameters.getRatioMatMapInteval(), units of MM

    private final double _swe;
    /*
     * simulated water equivalent(most of time, equal to TWE = WE+LIQW+TEX+STORGE; but if owe is available, when
     * exceeding WE tolerance(WETOL), equal to owe); units of MM
     */

    private final double _sasc; // simulated areal extent of snow cover

    private final double _snsgInCM; // simulated snow depth, units of CM

    private final double _prain; //precip as rain

    private final double _psfall; //precip as snow fall

    private final double _probg; //rain on bare ground within the period(MAT interval)

    private final double _psnwro; //snowpack outflow within the period(MAT interval)

    /**
     * Constructing the immutable object.
     * 
     * @param raim
     * @param swe
     * @param sasc
     * @param snsgInCM
     * @param prain
     * @param psfall
     * @param psnwro
     * @param probg
     */
    Snow17Results(final double[] raim,
                  final double swe,
                  final double sasc,
                  final double snsgInCM,
                  final double prain,
                  final double psfall,
                  final double psnwro,
                  final double probg)
    {
        _raim = raim.clone();
        _swe = swe;
        _sasc = sasc;
        _snsgInCM = snsgInCM; //set snow depth in units of CM
        _prain = prain;
        _psfall = psfall;
        _psnwro = psnwro;
        _probg = probg;
    }

    public double[] getRaim()
    {
        return _raim.clone(); //returns a copy of the array
    }

    public double getSasc()
    {
        return _sasc;
    }

    /**
     * Snow depth in units of CM
     */
    public double getSnsg()
    {
        return _snsgInCM;
    }

    public double getSwe()
    {
        return _swe;
    }

    public double getPsfall()
    {
        return _psfall;
    }

    public double getPrain()
    {
        return _prain;
    }

    public double getProbg()
    {
        return _probg;
    }

    public double getPsnwro()
    {
        return _psnwro;
    }

}
