package ohd.hseb.ohdmodels.snow17;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import ohd.hseb.util.Logger;

/**
 * Immutable class: once the object was constructed through the constructor, its state cannot be modified. This suits
 * the SNOW17 TECHNIQUE purpose: every technique has its default value. The optional presence in <properties> inside
 * run_info.xml can set the technique to the specified value.
 */
public class Snow17Technique
{
    private final Map<String, Boolean> _techniqueMap = new HashMap<String, Boolean>();

    public Snow17Technique(final Properties properties, final Logger log)
    {
        //set the default values first
        _techniqueMap.put(Snow17ModelConstants.PRINTSNW, false); //produces detailed daily information in the form of a text table, default is false
        _techniqueMap.put(Snow17ModelConstants.SACSNOW_FULL_VERSION, false); //for TECHNIQUE SACSNOW, default is Slim version
        _techniqueMap.put(Snow17ModelConstants.TECHNIQUE_SNOW, true); //skip model computation or not, default is true(run computation)
        _techniqueMap.put(Snow17ModelConstants.TECHNIQUE_UPSC, true); //controls AESCCHNG mod is allowed or not, default is true
        _techniqueMap.put(Snow17ModelConstants.TECHNIQUE_UPWE, true); //controls WECHNG mod is allowed or not, default is true
        _techniqueMap.put(Snow17ModelConstants.PRECIP_IS_ALL_RAIN, false); //true - all precip is treated as rain; false(default) - let pxtemp to determine it is rain or snow

        //now, depends on properties in run_info.xml, could re-set some of the values
        for(final String techName: _techniqueMap.keySet())
        {
            if(properties.containsKey(techName))
            {
                final boolean boolValue = Boolean.parseBoolean(properties.getProperty(techName));

                _techniqueMap.put(techName, boolValue);
                log.log(Logger.DEBUG, "Using the Run Time Option: " + techName + "[" + boolValue + "]");
            }
        }
    }

    /**
     * Get the boolean value for the specific SNOW17 technique.
     */
    public boolean getBoolValue(final String techName)
    {
        return _techniqueMap.get(techName);
    }

}
