package ohd.hseb.ohdmodels.ssarresv;

final public class Constants
{

    public final static String TITLE = "TITLE";
    public final static String UNITS = "UNITS";
    public final static String SAR = "SAR";
    public final static String ENDSAR = "ENDSAR";
    public final static String UPERBKWR = "UPERBKWR";
    public final static String ENDUPERB = "ENDUPERB";
    public final static String LWERBKWR = "LWERBKWR";
    public final static String ENDLWERB = "ENDLWERB";
    public final static String ThreeVAR = "3-VAR";
    public final static String END3_VAR = "END3-VAR";
    public final static String PARMS = "PARMS";
    public final static String ENDP = "ENDP";
    public final static String CARRYOVER = "CARRYOVER";
    public final static String ENDCO = "ENDCO";
    public final static String INFLOW = "INFLOW";
    public final static String ENDINFLW = "ENDINFLW";
    public final static String TIME_SERIES = "TIME-SERIES";
    public final static String ENDTS = "ENDTS";

    public final static String elevationStorage = "ELVSSTOR";
    public final static String qvsel = "QVSEL";
    public final static String maxel = "MAXEL";
    public final static String minel = "MINEL";
    public final static String minqrel = "MINQREL";
    public final static String shutResv = "SHUTRESV";
    public final static String backWater = "BACKWATR";

    public final static String backTable = "BACKTABL";
    public final static String threeVarTable = "3VARTABL";

    public final static int elevationStorageType = 0;
    public final static int backTableType = 1;
    public final static int threeVarTableType = 2;
    public final static int qvselType = 3;

    public final static String[] SAR_PARMS = {"ELVSSTOR", "QVSEL", "MAXEL", "MINEL", "MINQREL"};
    public final static int sar_ELVSSTOR = 0;
    public final static int sar_QVSEL = 1;
    public final static int sar_MAXEL = 2;
    public final static int sar_MINEL = 3;
    public final static int sar_MINQREL = 4;

    public final static String[] UPERBKWR_PARMS = {"ELVSSTOR", "BACKTABL", "BACKWATR", "MAXEL", "MINEL", "SHUTRESV"};
    public final static int uperbkwr_ELVSSTOR = 0;
    public final static int uperbkwr_BACKTABL = 1;
    public final static int uperbkwr_BACKWATR = 2;
    public final static int uperbkwr_MAXEL = 3;
    public final static int uperbkwr_MINEL = 4;
    public final static int uperbkwr_SHUTRESV = 5;

    public final static String[] LWERBKWR_PARMS = {"ELVSSTOR", "BACKTABL", "BACKWATR", "MAXEL", "MINEL", "SHUTRESV"};
    public final static int lwerbkwr_ELVSSTOR = 0;
    public final static int lwerbkwr_BACKTABL = 1;
    public final static int lwerbkwr_BACKWATR = 2;
    public final static int lwerbkwr_MAXEL = 3;
    public final static int lwerbkwr_MINEL = 4;
    public final static int lwerbkwr_SHUTRESV = 5;

    public final static String[] ThreeVAR_PARMS = {"3VARTABL", "BACKWATR",};
    public final static int threeVar_3VARTABL = 0;
    public final static int threeVar_BACKWATR = 1;

    public final static int doSAR = 0;
    public final static int doUPERBKWR = 1;
    public final static int doLWERBKWR = 2;
    public final static int doThreeVAR = 3;
    public final static int doCARRYOVER = 4;
    public final static int doINFLOW = 5;
    public final static int doTITLE = 6;
    public final static int doUNIT = 7;
    public final static int doBACKWATR = 8;
    public final static int doPARMS = 9;
    public final static int doTIME_SERIES = 10;

    public final static int doENDP = 99;

    public static int getIndexNumber(String s)
    {
        int index = -1;

        if(s.equals(SAR))
            index = doSAR;
        else if(s.equals(UPERBKWR))
            index = doUPERBKWR;
        else if(s.equals(LWERBKWR))
            index = doLWERBKWR;
        else if(s.equals(ThreeVAR))
            index = doThreeVAR;
        else if(s.equals(CARRYOVER))
            index = doCARRYOVER;
        else if(s.equals(INFLOW))
            index = doINFLOW;
        else if(s.equals(ENDP))
            index = doENDP;
        else if(s.equals(TITLE))
            index = doTITLE;
        else if(s.equals(UNITS))
            index = doUNIT;
        else if(s.equals(backWater))
            index = doBACKWATR;

        return index;
    }

    public final static String[] backTableVariables = {"outflow", "elevation_1", "control_parameter_1", "outflow_0",
        "elevation_2", "control_parameter_2"};
    public final static String[] ThreeVarTableVariables = {"outflow", "control_parameter_1", "elevation_1",
        "outflow_0", "control_parameter_2", "elevation_2"};
    public final static int Z_Variable = 0;
    public final static int Y_Variable = 1;
    public final static int X_Variable = 2;

    public final static String[] allCases = {INFLOW, UPERBKWR, ThreeVAR, SAR, LWERBKWR};

    public static int getAllCasesIndex(String aCase)
    {
        int index = 0;
        for(int i = 0; i < allCases.length; i++)
        {
            if(aCase.equals(allCases[i]))
            {
                index = i;
                break;
            }
        }
        return index;
    }

    public final static String[] allEndCases = {ENDINFLW, ENDUPERB, END3_VAR, ENDSAR, ENDLWERB};

    public final static int[] secondCases = {doPARMS, doTIME_SERIES, doCARRYOVER};

    public final static String[] allTimeSeries = {"INSTQI1", "INSTQI2",

    "INSTQO1", "INSTQO2",

    "MEANQOUT", "POOL", "STORAGE", "OBSQO", "OBSQOM", "OBSH", "BACKQI1", "BACKQI2", "BACKQIM",

    "TRIBQL1", "TRIBQL2"};

    public final static String[] allCarryover = {"Q-INST", "POOL", "STORAGE", "TRIBQL"};
    public final static String[][] allPARMS = {{"ELVSSTOR", "QVSEL"},

    {"BACKTABL", "3VARTABL"},

    {"BACKWATR"},

    {"MAXEL", "MINEL", "MINQREL", "SHUTRESV"}};

    // above constants are for parameters
    // below constants are for model states
    public final static int downstream = 0;
    public final static int upstream = 1;
    public final static String UNIT = "UNIT";
    public final static String DOWNSTREAM_RESERVOIR_INST_INFLOW = "DOWNSTREAM_RESERVOIR_INST_INFLOW";
    public final static String DOWNSTREAM_RESERVOIR_INST_OUTLOW = "DOWNSTREAM_RESERVOIR_INST_OUTLOW";
    public final static String DOWNSTREAM_RESERVOIR_ELEVATION = "DOWNSTREAM_RESERVOIR_ELEVATION";
    public final static String DOWNSTREAM_RESERVOIR_STORAGE = "DOWNSTREAM_RESERVOIR_STORAGE";
    public final static String DOWNSTREAM_RESERVOIR_NOT_USED = "DOWNSTREAM_RESERVOIR_NOT_USED";
    public final static String UPSTREAM_RESERVOIR_OUTLOW = "UPSTREAM_RESERVOIR_OUTLOW";
    public final static String UPSTREAM_RESERVOIR_ELEVATION = "UPSTREAM_RESERVOIR_ELEVATION";
    public final static String UPSTREAM_RESERVOIR_STORAGE = "UPSTREAM_RESERVOIR_STORAGE";
    public final static String TRIB_FLOW_INTO_DOWNSTREAM_RESERVOIR = "TRIB_FLOW_INTO_DOWNSTREAM_RESERVOIR";

}