package ohd.hseb.ohdmodels.ssarresv;

import java.util.HashMap;

import ohd.hseb.measurement.MeasuringUnit;

public class SsarresvRegulationTypes
{
    private final String regulationName;

    private final int regulationNumber;

    private final MeasuringUnit unit;

    public static HashMap<String, SsarresvRegulationTypes> regulationTypes = new HashMap<String, SsarresvRegulationTypes>();

    public SsarresvRegulationTypes(String regulationName, int regulationNumber, MeasuringUnit unit)
    {
        this.regulationName = regulationName;
        this.regulationNumber = regulationNumber;
        this.unit = unit;
        regulationTypes.put(regulationName, this);
    }

    public static SsarresvRegulationTypes freeflow = new SsarresvRegulationTypes("FREEFLOW",
                                                                                 0,
                                                                                 MeasuringUnit.unitlessInt);
    public static SsarresvRegulationTypes setQ = new SsarresvRegulationTypes("SETQ", 1, MeasuringUnit.cfs);
    public static SsarresvRegulationTypes setH = new SsarresvRegulationTypes("SETH", 2, MeasuringUnit.feet);
    public static SsarresvRegulationTypes setS = new SsarresvRegulationTypes("SETS", 3, MeasuringUnit.acft);
    public static SsarresvRegulationTypes setDQ = new SsarresvRegulationTypes("SETDQ", 4, MeasuringUnit.cfsd);
    public static SsarresvRegulationTypes setDH = new SsarresvRegulationTypes("SETDH", 5, MeasuringUnit.feet);
    public static SsarresvRegulationTypes setDS = new SsarresvRegulationTypes("SETDS", 6, MeasuringUnit.acft);

    public String getReguationName()
    {
        return regulationName;
    }

    public int getReguationNumber()
    {
        return regulationNumber;
    }

    public MeasuringUnit getRegulationUnit()
    {
        return unit;
    }

    public static SsarresvRegulationTypes getRegulationUsingName(String regulationName) throws Exception
    {

        if(regulationName.equals("FREEFLOW"))
            return SsarresvRegulationTypes.freeflow;
        if(regulationName.equals("SETQ"))
            return SsarresvRegulationTypes.setQ;
        if(regulationName.equals("SETH"))
            return SsarresvRegulationTypes.setH;
        if(regulationName.equals("SETS"))
            return SsarresvRegulationTypes.setS;
        if(regulationName.equals("SETDQ"))
            return SsarresvRegulationTypes.setDQ;
        if(regulationName.equals("SETDH"))
            return SsarresvRegulationTypes.setDH;
        if(regulationName.equals("SETDS"))
            return SsarresvRegulationTypes.setDS;
        throw new Exception("regulation name " + regulationName + " not recognized");

    }
}
