package ohd.hseb.ohdmodels.statq;

import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

final public class StatQModelDriver extends ModelDriver
{

    private static final String STATQ_EXE_NAME = "statq";

    public StatQModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new StatQModelState();
        _parameters = new StatQModelParameters();
        _savedParameters = new StatQModelParameters();
    }

    @Override
    public StatQModelParameters getParameters()
    {
        return (StatQModelParameters)_parameters;
    }

    @Override
    public StatQModelState getState()
    {
        return (StatQModelState)_state;
    }

    @Override
    public StatQModelParameters getPreviousParameters()
    {
        return (StatQModelParameters)_savedParameters;
    }

    @Override
    public void execute() throws Exception
    {

        System.out.println("ts size = " + _tsList.size());

        // only timeseries containing L3/T data should be considered as driving time series for this model
        for(final RegularTimeSeries timeSeries: _tsList)
        {
            System.out.println("(timeSeries.getMeasuringUnit().getType() = " + timeSeries.getMeasuringUnit().getType());
            if(timeSeries.getMeasuringUnit().getType() == MeasuringUnitType.discharge)
            {
                _drivingTs = timeSeries;
                _logger.log(Logger.DEBUG,
                            "Driving Time Series set to " + _drivingTs.getLocationId() + " "
                                + _drivingTs.getTimeSeriesType() + " " + _drivingTs.getIntervalInHours());
            }
        }

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        //Send in work dir and state dir
        final LegacyModelAdapter statQAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        if(!this.getParameters().isParamExisting(OHDConstants.OPERATION_CONTENTS_TAG))
            this.getParameters().setOperationContentFromParameters();

        statQAdapter.writeStandAloneFiles();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument
        statQAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + STATQ_EXE_NAME, null);

//        // Load the state results
//        getState().loadState(statQAdapter.getOutputStateFileName(), _logger);
//
//        //Set state date and time
//        getState().setDateTime(getComputationEndTime());

        //load the results
//        final List<RegularTimeSeries> resultsList = statQAdapter.readOutputFlatFilesToLists();
//
//        for(int i = 0; i < resultsList.size(); i++)
//        {
//            addTStoResultMap(resultsList.get(i));
//        }
    }

}
