package ohd.hseb.ohdmodels.statq;

import java.util.List;

import ohd.hseb.time.DateTime;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ParameterType.Row;
import ohd.hseb.util.fews.ParameterType.Table;
import ohd.hseb.util.fews.ohdmodels.LegacyModelParameters;

/**
 * To extend the legacy model parameters
 * 
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @see LegacyModelParameters
 * @version 1.0
 * @since January, 2010
 */

final public class StatQModelParameters extends LegacyModelParameters
{
    public final static String SAC_Parameters = "SAC_PAR";
    public final static String SAC_States = "SAC_ST";
    public final static String RUT_Parameters = "RUT_PAR";
    public final static String RUT_States = "RUT_ST";
    public final static String PEAndPE_ADJ = "PE/PE_ADJ";

    //public final static String INPUT_PATH = "INPUT_PATH";
    public final static String START_MONTH_YEAR = "START_DATE_MONTH_YEAR";
    public final static String END_MONTH_YEAR = "END_DATE_MONTH_YEAR";
    public final static String BASIN_AREA_KM2 = "BASIN_AREA_IN_KM2";

    public final static String PROCESSING_TIMESTEP = "PROCESSING_TIMESTEP_IN_HOURS";
    public final static String NUMBER_OF_LINES_OF_DATA_TO_DISPLAY = "NUMBER_OF_LINES_OF_DATA_TO_DISPLAY";
    public final static String NUMBER_OF_EQUAL_FLOW_INTERVALS = "NUMBER_OF_EQUAL_FLOW_INTERVALS";
    public final static String CALCULATE_STATS_FOR_CASES_GREATER_THAN = "CALCULATE_STATS_FOR_CASES_GREATER_THAN";
    public final static String PAIR_OF_FLOW_INTERVALS = "PAIR_OF_FLOW_INTERVALS_IN_CMS";
    public final static String EVENT_START_AND_END_DATES = "EVENT_START_AND_END_DATES_IN_MMDDYYYYHH";
    public final static String EVENT_START_DATES = "EVENT_START_DATES";
    public final static String EVENT_END_DATES = "EVENT_END_DATES";
    public final static String THRESHOLD_VALUE = "THRESHOLD_VALUE";
    public final static String THRESHOLD_WINDOW_LENGTH_HOURS = "THRESHOLD_WINDOW_LENGTH_HOURS";
    public final static String PARTITION_NUMBER_MONTHS_FOR_ACCUMULATIVE_FLOW = "PARTITION_NUMBER_MONTHS_FOR_ACCUMULATIVE_FLOW";

    public final static String AT_TAG = "@";
    public final static String AT_A_TAG = "@A ";
    public final static String AT_D_TAG = "@D ";
    public final static String AT_E_TAG = "@E ";
    public final static String AT_F_TAG = "@F ";
    public final static String AT_G_TAG = "@G ";
    public final static String AT_H_TAG = "@H ";
    public final static String AT_I_TAG = "@I ";
    public final static String AT_Q_TAG = "@Q ";
    public final static String AT_T_TAG = "@T ";
    public final static String WHITE_SPACE_TAG = " ";

    public void setOperationContentFromParameters() throws Exception
    {
        final StringBuffer controlFile = new StringBuffer();

        controlFile.append(AT_TAG);
        controlFile.append(OHDConstants.NEW_LINE);
        final String startDate = super.getStringDataParameter(START_MONTH_YEAR);
        controlFile.append(startDate.substring(0, 2));
        controlFile.append(WHITE_SPACE_TAG);
        controlFile.append(startDate.substring(2));
        controlFile.append(WHITE_SPACE_TAG);
        final String endDate = super.getStringDataParameter(END_MONTH_YEAR);
        controlFile.append(endDate.substring(0, 2));
        controlFile.append(WHITE_SPACE_TAG);
        controlFile.append(endDate.substring(2));
        controlFile.append(OHDConstants.NEW_LINE);
        controlFile.append(super.getDoubleDataParameter(BASIN_AREA_KM2));
        controlFile.append(OHDConstants.NEW_LINE);
        controlFile.append(OHDConstants.NEW_LINE);

        controlFile.append(AT_T_TAG);
        controlFile.append(super.getIntDataParameter(PROCESSING_TIMESTEP));
        controlFile.append(OHDConstants.NEW_LINE);
        controlFile.append(OHDConstants.NEW_LINE);

        if(super.isParamExisting(NUMBER_OF_LINES_OF_DATA_TO_DISPLAY))
        {
            controlFile.append(AT_A_TAG);
            controlFile.append(super.getIntDataParameter(NUMBER_OF_LINES_OF_DATA_TO_DISPLAY));
            controlFile.append(OHDConstants.NEW_LINE);
            controlFile.append(OHDConstants.NEW_LINE);
        }

        if(super.isParamExisting(NUMBER_OF_EQUAL_FLOW_INTERVALS))
        {
            controlFile.append(AT_D_TAG);
            controlFile.append(super.getIntDataParameter(NUMBER_OF_EQUAL_FLOW_INTERVALS));
            controlFile.append(OHDConstants.NEW_LINE);
            controlFile.append(OHDConstants.NEW_LINE);
        }

        if(super.isParamExisting(CALCULATE_STATS_FOR_CASES_GREATER_THAN))
        {

            final Table calculatedStatsForCasesGreaterThanTable = super.getTableDataParameter(CALCULATE_STATS_FOR_CASES_GREATER_THAN);
            final List<Row> calculatedStatsForCasesGreaterThanRowList = calculatedStatsForCasesGreaterThanTable.getRow();
            if(calculatedStatsForCasesGreaterThanRowList != null
                && calculatedStatsForCasesGreaterThanRowList.size() > 0)
            {
                controlFile.append(AT_E_TAG);
                controlFile.append(calculatedStatsForCasesGreaterThanRowList.size());
                for(final Row calculatedStatsForCasesGreaterThanRow: calculatedStatsForCasesGreaterThanRowList)
                {
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(calculatedStatsForCasesGreaterThanRow.getA());
                }
                controlFile.append(OHDConstants.NEW_LINE);
                controlFile.append(OHDConstants.NEW_LINE);
            }
        }

        if(super.isParamExisting(PAIR_OF_FLOW_INTERVALS))
        {

            final Table pairFlowIntervalTable = super.getTableDataParameter(PAIR_OF_FLOW_INTERVALS);
            final List<Row> pairFlowIntervalRowList = pairFlowIntervalTable.getRow();
            if(pairFlowIntervalRowList != null && pairFlowIntervalRowList.size() > 0)
            {
                controlFile.append(AT_F_TAG);
                controlFile.append(pairFlowIntervalRowList.size());

                for(final Row pairFlowIntervalRow: pairFlowIntervalRowList)
                {
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(pairFlowIntervalRow.getA());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(pairFlowIntervalRow.getB());
                }
                controlFile.append(OHDConstants.NEW_LINE);
                controlFile.append(OHDConstants.NEW_LINE);
            }
        }

        if(super.isParamExisting(EVENT_START_AND_END_DATES))
        {

            final Table tableEventStartDates = super.getTableDataParameter(EVENT_START_AND_END_DATES);
            final List<Row> eventStartDatesRowList = tableEventStartDates.getRow();
            if(eventStartDatesRowList != null && eventStartDatesRowList.size() > 0)
            {
                controlFile.append(AT_G_TAG);
                controlFile.append(eventStartDatesRowList.size());
                controlFile.append(OHDConstants.NEW_LINE);

                for(final Row eventstartDatesRow: eventStartDatesRowList)
                {
                    final DateTime eventStartDate = DateTime.parseMMDDYYYYHHZ(eventstartDatesRow.getA());
                    controlFile.append(eventStartDate.hour());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventStartDate.month());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventStartDate.dayOfMonth());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventStartDate.year());
                    controlFile.append(OHDConstants.NEW_LINE);
                    final DateTime eventEndDate = DateTime.parseMMDDYYYYHHZ(eventstartDatesRow.getB());
                    controlFile.append(eventEndDate.hour());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventEndDate.month());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventEndDate.dayOfMonth());
                    controlFile.append(WHITE_SPACE_TAG);
                    controlFile.append(eventEndDate.year());
                    controlFile.append(OHDConstants.NEW_LINE);
                    controlFile.append(OHDConstants.NEW_LINE);
                }
                controlFile.append(OHDConstants.NEW_LINE);
            }
        }

        if(super.isParamExisting(THRESHOLD_VALUE))
        {
            controlFile.append(AT_H_TAG);
            controlFile.append(super.getDoubleDataParameter(THRESHOLD_VALUE));
            controlFile.append(WHITE_SPACE_TAG);
            controlFile.append(super.getIntDataParameter(THRESHOLD_WINDOW_LENGTH_HOURS));
            controlFile.append(OHDConstants.NEW_LINE);
            controlFile.append(OHDConstants.NEW_LINE);
        }

        if(super.isParamExisting(PARTITION_NUMBER_MONTHS_FOR_ACCUMULATIVE_FLOW))
        {
            controlFile.append(AT_I_TAG);
            controlFile.append(super.getIntDataParameter(PARTITION_NUMBER_MONTHS_FOR_ACCUMULATIVE_FLOW));
            controlFile.append(OHDConstants.NEW_LINE);
            controlFile.append(OHDConstants.NEW_LINE);
        }

        controlFile.append(AT_Q_TAG);
        controlFile.append(OHDConstants.NEW_LINE);
        controlFile.append(OHDConstants.NEW_LINE);
        controlFile.append(OHDConstants.NEW_LINE);

        super.insertParameter(OHDConstants.OPERATION_CONTENTS_TAG, controlFile.toString());

    }
}
