package ohd.hseb.ohdmodels.tatum;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

import ohd.hseb.util.fews.ohdmodels.ModelParameters;
import ohd.hseb.util.fews.ohdmodels.ModelState;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.Parameters;
import ohd.hseb.util.fews.StringIntegerComparator;

public class TatumModelState extends ModelState
{

    private int _numberLayers = 0;;
    private int[] _numberCarryOverByLayer;
    private String _unitType = OHDConstants.UNIT_METRIC;;
    private List<double[]> _carryOverList = new ArrayList<double[]>();

    /**
     * Extract values from super._statesMap into instance variables. The values in super._statessMap are set by parsing
     * the initial state file in OHDFewsAdapter.java.
     */
    @Override
    public void extractValuesFromMap() throws Exception
    {
        if(_numberLayers > 0)
        {
            for(int layerId = 0; layerId < _numberLayers; layerId++)
                _carryOverList.add(this.getTatumCarryOverByLayer(layerId + 1));
        }

    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.ohdmodels.ModelState#doCarryOverTransfer(ohd.hseb.ohdmodels.ModelParameters,
     * ohd.hseb.ohdmodels.ModelParameters)
     */
    @Override
    public void doCarryOverTransfer(final ModelParameters savedParams, final ModelParameters params) throws Exception
    {
        boolean errorNumberCoeficientsByLayer = false;
        boolean errorUpperLimitFlowByLayer = false;
        final TatumModelParameters savedParameters = (TatumModelParameters)savedParams;
        final TatumModelParameters parameters = (TatumModelParameters)params;

        final int numberOfLayersOld = savedParameters.getNumberLayers();
        final int numberOfLayersNew = parameters.getNumberLayers();

        final double[] numberCoefficientsByLayerOld = savedParameters.getNumberCoefficientsByLayer();
        final double[] numberCoefficientsByLayerNew = parameters.getNumberCoefficientsByLayer();

        if(_logger.getPrintDebugInfo() > 0)
        {
            _logger.log(Logger.DEBUG, "TatumModelState before carry over transfer " + this.getStateMap());
        }

        if(numberOfLayersNew == numberOfLayersOld)
        {
            // check to see if number of coefficients per layer are the same.
            if(savedParameters.getNumberCoefficientsByLayer().length == parameters.getNumberCoefficientsByLayer().length)
            {
                for(int numberLayer = 0; numberLayer < savedParameters.getNumberCoefficientsByLayer().length; numberLayer++)
                {
                    // Number of tatum coefficients for each layer beginning with bottom layer. - From definition of field
                    // even the number of coefficients is stored as a double value it must contain an integer value. (1.4 does not make sense) That is the reason of the casting.
                    // If we don't cast it could give us wrong results. Legacy code truncate the values before compare them.
                    if((int)savedParameters.getNumberCoefficientsByLayer()[numberLayer] != (int)parameters.getNumberCoefficientsByLayer()[numberLayer])
                    {
                        errorNumberCoeficientsByLayer = true;
                    }
                }

                if(!errorNumberCoeficientsByLayer)
                {

                    // Check to see if time series data time interval are the same.
                    if(savedParameters.getInflowTimeSerieTimeStep() == parameters.getInflowTimeSerieTimeStep())
                    {
                        //Check to see if maximum limits of flow for each layer are the same

                        // The upper limit of flow for each layer is not needed if there is only one layer 
                        if(numberOfLayersNew > 1)
                        {
                            if(savedParameters.getUpperLimitFlowByLayer().length == parameters.getUpperLimitFlowByLayer().length)
                            {
                                for(int numberLayerOld = 0; numberLayerOld < savedParameters.getUpperLimitFlowByLayer().length; numberLayerOld++)
                                {
                                    if(Math.abs(savedParameters.getUpperLimitFlowByLayer()[numberLayerOld]
                                        - parameters.getUpperLimitFlowByLayer()[numberLayerOld]) > 0.001)
                                    {
                                        errorUpperLimitFlowByLayer = true;
                                    }
                                }
                            }
                        }
                        if(!errorUpperLimitFlowByLayer)
                        {
                            //set new carryover to old carryover and end execution - do nothing in this case.
                            _logger.log(Logger.DEBUG, "EXIT carryover - continue with computation");

                            return;
                        }
                    }
                } //!errorNumberCoeficientsByLayer
            }
        }

        boolean executeCode = true;
        double[] carryOverValuesByLayersOld;
        double[] carryOverValuesByLayersNew;
        double[] carryOverValuesByLayers;
        final int[] numberCarryOverByLayerNew = new int[numberCoefficientsByLayerNew.length];

        double[] coefficientsByLayersNew;
        double[] coefficientsByLayersOld;
        final double[] coefficientsByLayers;

        for(int i = 0; i < numberCoefficientsByLayerNew.length; i++)
        {
            numberCarryOverByLayerNew[i] = Double.valueOf(numberCoefficientsByLayerNew[i]).intValue() - 1;
        }

        final List<double[]> carryOverList = new ArrayList<double[]>();

        if(numberOfLayersNew > 0)
        {
            for(int layerId = 0; layerId < numberOfLayersNew; layerId++)
                carryOverList.add(new double[numberCarryOverByLayerNew[layerId]]);
        }

        double flow = 0.0;
        final double[] upperLimitFlowLayerOld = savedParameters.getUpperLimitFlowByLayer();
        final double[] upperLimitFlowLayerNew = parameters.getUpperLimitFlowByLayer();

        for(int layerNumber = 1; layerNumber <= numberOfLayersOld; layerNumber++)
        {
            carryOverValuesByLayersOld = this.getTatumCarryOverValuesByLayer(numberOfLayersOld - layerNumber);
            carryOverValuesByLayersNew = this.getTatumCarryOverValuesByLayer(numberOfLayersOld - layerNumber);

            if(layerNumber < numberCoefficientsByLayerNew.length)
            {
                coefficientsByLayersNew = parameters.getNumberCoefficientsByLayer();
            }
            else
            {
                coefficientsByLayersNew = new double[0];
            }
            coefficientsByLayersOld = savedParameters.getNumberCoefficientsByLayer();

            if(carryOverValuesByLayersOld.length > 0)
                for(int carryOVerNumber = 0; carryOVerNumber < carryOverValuesByLayersOld.length; carryOVerNumber++)
                {
                    flow = 0.0;
                    executeCode = true;
                    final int coefficientByLayer1 = Double.valueOf(coefficientsByLayersOld[coefficientsByLayersOld.length - 1])
                                                          .intValue() - 1;
                    if(carryOVerNumber < coefficientByLayer1 && numberOfLayersOld > 1)
                    {
                        final double diff = Math.abs(upperLimitFlowLayerOld[0]
                            - carryOverValuesByLayersOld[carryOVerNumber]);
                        if(diff > 0.001)
                        {
                            flow = carryOverValuesByLayersOld[carryOVerNumber];
                            executeCode = false;
                        }
                        else
                        {
                            flow = upperLimitFlowLayerOld[0];
                        }
                    }
                    if(executeCode)
                    {

                        for(int layerNumber2 = 2; layerNumber2 <= numberOfLayersOld; layerNumber2++)
                        {
                            {
                                carryOverValuesByLayers = this.getTatumCarryOverValuesByLayer(numberOfLayersOld
                                    - layerNumber2);
                                if(carryOverValuesByLayers.length > 0
                                    && carryOVerNumber < carryOverValuesByLayers.length)
                                {
                                    if(carryOverValuesByLayers[carryOVerNumber] >= 0.001)
                                    {
                                        flow = upperLimitFlowLayerOld[layerNumber2 - 2]
                                            + carryOverValuesByLayers[carryOVerNumber];
                                    }
                                }
                            }
                        }
                    }
                    if(layerNumber <= numberOfLayersNew && layerNumber > 1)
                    {
                        if(layerNumber == numberOfLayersNew)
                        {
                            if(flow > upperLimitFlowLayerNew[layerNumber - 2])
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = flow
                                    - upperLimitFlowLayerNew[layerNumber - 2];
                            }
                            else
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = 0.0;
                            }

                        }
                        else
                        {
                            if(upperLimitFlowLayerNew[layerNumber - 2] > flow)
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = 0.0;
                            }
                            if(upperLimitFlowLayerNew[layerNumber - 2] <= flow
                                && upperLimitFlowLayerNew[layerNumber - 1] > flow)
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = flow
                                    - upperLimitFlowLayerNew[layerNumber - 2];
                            }
                            if(upperLimitFlowLayerNew[layerNumber - 1] < flow)
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = upperLimitFlowLayerNew[layerNumber - 1]
                                    - upperLimitFlowLayerNew[layerNumber - 2];
                            }
                        }
                    }
                    else
                    {
                        if(numberOfLayersNew == 1)
                        {
                            carryOverValuesByLayersNew[carryOVerNumber] = flow;
                        }
                        else
                        {
                            if(flow < upperLimitFlowLayerNew[0])
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = flow;
                            }
                            else
                            {
                                carryOverValuesByLayersNew[carryOVerNumber] = upperLimitFlowLayerNew[0];
                            }
                        }

                    }

                } // carryover loop

            // Apply carryover if any.
            if(carryOverValuesByLayersNew.length != carryOverValuesByLayersOld.length)
            {

                for(int carryOVerNumber = carryOverValuesByLayersOld.length; carryOVerNumber > carryOverValuesByLayersNew.length; carryOVerNumber++)
                {
                    carryOverValuesByLayersNew[carryOVerNumber] = carryOverValuesByLayersNew[carryOVerNumber - 1];
                }

            }
            //this.updateTatumCarryOverValuesByLayer((numberOfLayersNew - layerNumber), carryOverValuesByLayersNew);
            if(layerNumber <= numberOfLayersNew)
                carryOverList.set((numberOfLayersNew - layerNumber), carryOverValuesByLayersNew);

        } // layer loop

        this.setNumberCarryOverByLayer(parameters.getNumberCoefficientsByLayer());
        _carryOverList = new ArrayList<double[]>();

        getStateMap().clear();

        double[] valuesCarryOverByLayer;
        for(int layerNumber = 0; layerNumber < parameters.getNumberLayers(); layerNumber++)
        {
            valuesCarryOverByLayer = carryOverList.get(layerNumber);
            final int numerCarryOverByLayer = this.getNumberCarryOverByLayer(layerNumber + 1);
            final double[] carryOver = new double[numerCarryOverByLayer];

            for(int carryOVerNumber = 0; carryOVerNumber < numerCarryOverByLayer; carryOVerNumber++)
            {
                if(valuesCarryOverByLayer.length >= numerCarryOverByLayer)
                    carryOver[carryOVerNumber] = valuesCarryOverByLayer[carryOVerNumber];
            }
            _carryOverList.add(carryOver);
        }
        this.setUnitType(OHDConstants.UNIT_METRIC);
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.fews.State#getStringsFromState()
     */
    @Override
    protected String getStringsFromState()
    {
        // TODO Auto-generated method stub
        return super.getStringsFromState();
    }

    public TatumModelState()
    {
        super();
    }

    public TatumModelState(final int whichMap)
    {
        super(whichMap);
    }

    /**
     * states of all models are stored in _statesMap. TatumModelState, LayCoefModelState could further override
     * ModelState toString(). Then this call writeState() will print out more information.
     */
    @Override
    public void writeState(final String outputStateFileName, final Logger logger) throws Exception
    {
        final BufferedWriter outFile = new BufferedWriter(new FileWriter(outputStateFileName));

        try
        {
            //print out states in alphabetic order
            outFile.write(getStringsFromState(new StringIntegerComparator(false), getStateMap()));
        }
        finally
        {
            outFile.close();
        }

        //reset the states map
        getStateMap().clear();
        logger.log(Logger.DEBUG, "Output the state to the file: " + outputStateFileName);
    }

    /**
     * @return the numberLayers
     */
    private int getNumberLayers()
    {
        return _numberLayers;
    }

    /**
     * @return the numberCarryOverByLayer
     */
    public int getNumberCarryOverByLayer(final int layerId)
    {
        return _numberCarryOverByLayer[layerId - 1];

    }

//    /**
//     * @param numberLayers the numberLayers to set
//     */
//    private void setNumberLayers(final int numberLayers)
//    {
//        this._numberLayers = numberLayers;
//    }

    /**
     * @param numberCarryOverByLayer the numberCarryOverByLayer to set
     */
    public void setNumberCarryOverByLayer(final double[] numberCarryOverByLayer)
    {
        _numberCarryOverByLayer = new int[numberCarryOverByLayer.length];

        for(int i = 0; i < numberCarryOverByLayer.length; i++)
        {
            _numberCarryOverByLayer[i] = Double.valueOf(numberCarryOverByLayer[i]).intValue() - 1;

        }
        _numberLayers = _numberCarryOverByLayer.length;
    }

    /**
     * @param layerId
     * @return
     * @throws Exception
     */
    private double[] getTatumCarryOverByLayer(final int layerId) throws Exception
    {
        final double[] tatumCarryOver = new double[getNumberCarryOverByLayer(layerId)];
        for(int numberCarryOver = 0; numberCarryOver < getNumberCarryOverByLayer(layerId); numberCarryOver++)
        {
            tatumCarryOver[numberCarryOver] = getDoubleDataState("LAYER" + layerId + "_FLOW#" + numberCarryOver);
        }
        return tatumCarryOver;
    }

    /**
     * @param layerId
     * @return
     * @throws Exception
     */
    public double[] getTatumCarryOverValuesByLayer(final int layerId) throws Exception
    {
        if(_carryOverList.size() >= layerId)
            return this._carryOverList.get(layerId);
        else
            return null;

    }

    /**
     * @param layerId
     * @param tatumCarryOverValues
     */
    public void updateTatumCarryOverValuesByLayer(final int layerId, final double[] tatumCarryOverValues)
    {
        _carryOverList.set(layerId, tatumCarryOverValues);
    }

    /**
     * @param layerId
     * @param tatumCarryOverValues
     */
    private void updateTatumCarryOverbyLayer(final int layerId, final double[] tatumCarryOverValues)
    {
        for(int numberCarryOver = 0; numberCarryOver < tatumCarryOverValues.length; numberCarryOver++)
        {
            super.setStateValue("LAYER" + layerId + "_FLOW#" + numberCarryOver, tatumCarryOverValues[numberCarryOver]);
        }

    }

    /**
     * @return the unitType
     */
    public String getUnitType()
    {
        return _unitType;
    }

    /**
     * @param unitType the unitType to set
     */
    public void setUnitType(final String unitType)
    {
        _unitType = unitType;
        super.setStateValue(OHDConstants.UNIT_TAG, unitType);
    }

    public void setCarryOverValues()
    {
        int layerNumber = 1;
        for(final double[] carryOver: _carryOverList)
        {
            this.updateTatumCarryOverbyLayer(layerNumber, carryOver);
            layerNumber++;
        }
    }

    public void validateState(final Parameters params) throws Exception
    {

        final TatumModelParameters tatumParams = (TatumModelParameters)params;
        this.setNumberCarryOverByLayer(tatumParams.getNumberCoefficientsByLayer());
        this.setUnitType(OHDConstants.UNIT_METRIC);
        this.extractValuesFromMap();
    }

} // end class
