package ohd.hseb.ohdutilities.ffg;

/**
 * NO_ADJUSTMENT(legacy: 0), FORECAST_FLOW_AT_HOURS(legacy: 1), HIGHEST_FORECAST_FLOW_OVER_NEXT_HOURS(legacy: 2),
 * HIGHEST_FORECAST_FLOW_IN_TIMESERIES(legacy: 3), REDUCE_RUNOFF_BY_STORM_RUNOFF(legacy: 4).
 */
public enum FFG_HIGH_FLOW_ADJUST_OPTION
{
    NO_ADJUSTMENT_AS_0(FfgConstants.FFG_NO_ADJUSTMENT), //
    FORECAST_FLOW_AT_HOURS_AS_1(FfgConstants.FFG_FORECAST_FLOW_AT_HOURS), //
    HIGHEST_FORECAST_FLOW_OVER_NEXT_HOURS_AS_2(FfgConstants.FFG_HIGHEST_FORECAST_FLOW_OVER_NEXT_HOURS), //
    HIGHEST_FORECAST_FLOW_IN_TIMESERIES_AS_3(FfgConstants.FFG_HIGHEST_FORECAST_FLOW_IN_TIMESERIES), //
    REDUCE_RUNOFF_BY_STORM_RUNOFF_AS_4(FfgConstants.FFG_REDUCE_RUNOFF_BY_STORM_RUNOFF); //only used by FFH, not used by Gridded FFG

    private String _paramValueStr;

    private FFG_HIGH_FLOW_ADJUST_OPTION(final String optionStr)
    {
        _paramValueStr = optionStr;
    }

    /**
     * the parameter value of the parameter tag {@link FfgConstants#FFG_HIGH_FLOW_ADJUST_TAG}
     */
    public String paramValue()
    {
        return _paramValueStr;
    }

    /** the parameter tag String */
    public static String paramName()
    {
        return FfgConstants.FFG_HIGH_FLOW_ADJUST_TAG;
    }

    /**
     * Convert from a String to an enum element. If the String does not match with any option, throws an Exception.
     * 
     * @param ffhHighFlowAdjustOption
     */
    public static FFG_HIGH_FLOW_ADJUST_OPTION convertFromString(final String ffhHighFlowAdjustOption) throws Exception
    {
        for(final FFG_HIGH_FLOW_ADJUST_OPTION e: values())
        {
            if(e.paramValue().equalsIgnoreCase(ffhHighFlowAdjustOption))
            {
                return e;
            }
        }

        throw new Exception(ffhHighFlowAdjustOption + " is a wrong string value for the parameter " + paramName());
    }
}
