package ohd.hseb.ohdutilities.ffg;

import ohd.hseb.ohdutilities.ffg.griddedFfg.GriddedFFGConstants;

/**
 * NO_ADJUSTMENT(legacy: 0), FFH_ADJUST_RUNOFF(legacy: 1), FFH_USE_FIELDS_AS_FFG(legacy: 2, use intensity value as ffg),
 * FFH_USE_THRESHOLD_RUNOFF_AS_FFG(legacy: 3)
 */
public enum FFG_RUNOFF_ADJUST_OPTION
{
    NO_ADJUSTMENT_AS_0(FfgConstants.FFG_NO_ADJUSTMENT), //
    ADJUST_RUNOFF_AS_1(FfgConstants.FFG_ADJUST_RUNOFF), //
    USE_FIELDS_AS_FFG_AS_2(FfgConstants.FFG_USE_FIELDS_AS_FFG), //
    USE_THRESHOLD_RUNOFF_AS_FFG_AS_3(FfgConstants.FFG_USE_THRESHOLD_RUNOFF_AS_FFG), //
    ADJUST_FFG_AS_5(GriddedFFGConstants.ADJUST_FFG_TAG), // used only by Gridded FFG
    EXCLUDE_FROM_GRID_COMPUTATIONS_AS_9(GriddedFFGConstants.EXCLUDE_FROM_GRID_COMPUTATIONS_TAG); // used only by Gridded FFG

    private String _paramValueStr;

    private FFG_RUNOFF_ADJUST_OPTION(final String optionStr)
    {
        _paramValueStr = optionStr;
    }

    /**
     * the parameter value of the parameter tag {@link FfgConstants#FFG_RUNOFF_ADJUST_TAG}
     */
    public String paramValue()
    {
        return _paramValueStr;
    }

    /** the parameter tag String */
    public static String paramName()
    {
        return FfgConstants.FFG_RUNOFF_ADJUST_TAG;
    }

    /**
     * Convert from a String to an enum element. If the String does not match with any option, throws an Exception.
     * 
     * @param ffhRunoffAdjustOption
     */
    public static FFG_RUNOFF_ADJUST_OPTION convertFromString(final String ffhRunoffAdjustOption) throws Exception
    {
        for(final FFG_RUNOFF_ADJUST_OPTION e: values())
        {
            if(e.paramValue().equalsIgnoreCase(ffhRunoffAdjustOption))
            {
                return e;
            }
        }

        throw new Exception(ffhRunoffAdjustOption + " is a wrong string value for the parameter " + paramName());
    }
}
