package ohd.hseb.ohdutilities.ffg;

final public class FfgConstants
{
    private FfgConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    public final static String FFG_BASIN_BOUNDARY_ID_TAG = "FFG_BASIN_BOUNDARY_ID";
    public final static String FFG_DURATION_TAG = "FFG_DURATION";
    public final static String FFG_MINIMUM_THRESHOLD_RUNOFF_TAG = "FFG_MINIMUM_THRESHOLD_RUNOFF";
    public final static String FFG_MAXIMUM_THRESHOLD_RUNOFF_TAG = "FFG_MAXIMUM_THRESHOLD_RUNOFF";
    public final static String FFG_RAINFALL_RUNOFF_MODEL_NAME_TAG = "FFG_RAINFALL_RUNOFF_MODEL_NAME";
    public final static String FFG_RAINFALL_RUNOFF_MODEL_ID_TAG = "FFG_RAINFALL_RUNOFF_MODEL_ID";
    public final static String FFG_SNOW_MODEL_NAME_TAG = "FFG_SNOW_MODEL_NAME";
    public final static String FFG_SNOW_MODEL_ID_TAG = "FFG_SNOW_MODEL_ID";

    public final static String FFG_SEGMENT_ID_TAG = "FFG_SEGMENT_ID"; //not used by model, but used by migration script

    /* Replace 0 = only use 1, 3 and 6 hour durations */
    public final static String FFG_DURATION_1_3_6_HR_TAG = "1_3_6_HR";
    /* Replace 1 = include 12 hour duration */
    public final static String FFG_DURATION_1_3_6_12_HR_TAG = "1_3_6_12_HR";
    /* Replace 2 = include 12 and 24 hour duration */
    public final static String FFG_DURATION_1_3_6_12_24_HR_TAG = "1_3_6_12_24_HR";

    /** "SNOW-17" */
    public final static String SNOW_MODEL_NAME = "SNOW-17";
    /** "SAC-SMA" */
    public final static String SAC_MODEL_NAME = "SAC-SMA";
    /** "API-CONT" */
    public final static String API_CONT_MODEL_NAME = "API-CONT";
    public final static String FFG_PARAMETER_FILE_NAME = "ffgParameters";

    public final static String RUNOFF_MODEL_PARAMETERS_ROOT_DIR = "runoffModelParametersRootDir";
    public final static String SNOW_MODEL_PARAMETERS_ROOT_DIR = "snowModelParametersRootDir";
    public final static String RUNOFF_MODEL_STATES_ROOT_DIR = "runoffModelStatesRootDir";
    public final static String SNOW_MODEL_STATES_ROOT_DIR = "snowModelStatesRootDir";

    public final static String FLOOD_FLOW_ID_TAG = "floodFlowId";
    public final static String FFG_LOCATION_ID_TAG = "LOCATION_ID";

    /** default max threshold runoff is 2.5 inch */
    final static double FFG_MAX_THRESHOLD_RUNOFF_DEFAULT_VALUE = 2.5;

    /** default min threshold runoff is 0.1 inch */
    final static double FFG_MIN_THRESHOLD_RUNOFF_DEFAULT_VALUE = 0.1;

    /** USER CONTROL */
    public final static String FFG_USER_CTRL_HIGH_FLOW_ADJUST_TAG = "USER_CTRL_HIGH_FLOW_ADJUST";
    public final static String FFG_USER_CTRL_RUNOFF_ADJUST_TAG = "USER_CTRL_RUNOFF_ADJUST";
    public final static String FFG_USER_CTRL_CHECK_DECREASING_FFG_TAG = "USER_CTRL_CHECK_DECREASING_FFG";

    public final static String FFG_MIN_VALUE_TAG = "MIN_FFG";
    public final static String FFG_MAX_VALUE_TAG = "MAX_FFG";

    public final static String FFG_PERCENT_IMPERVIOUS_TAG = "PERCENT_IMPERVIOUS";

    /** FFG_HIGH_FLOW_ADJUST options */
    public final static String FFG_HIGH_FLOW_ADJUST_TAG = "HIGH_FLOW_ADJUST_OPTION";
    /** no adjustment = 0 */
    public final static String FFG_NO_ADJUSTMENT = "NO_ADJUSTMENT";
    /** forecast flow at hours entered = 1 */
    public final static String FFG_FORECAST_FLOW_AT_HOURS = "FORECAST_FLOW_AT_HOURS";
    /** highest forecast flow over next hours = 2 */
    public final static String FFG_HIGHEST_FORECAST_FLOW_OVER_NEXT_HOURS = "HIGHEST_FORECAST_FLOW_OVER_NEXT_HOURS";
    /** highest forecast flow in TS = 3 */
    public final static String FFG_HIGHEST_FORECAST_FLOW_IN_TIMESERIES = "HIGHEST_FORECAST_FLOW_IN_TIMESERIES";
    /** reduce runoff by storm runoff = 4 */
    public final static String FFG_REDUCE_RUNOFF_BY_STORM_RUNOFF = "REDUCE_RUNOFF_BY_STORM_RUNOFF";

    public final static String FFG_RUNOFF_ADJUST_TAG = "RUNOFF_ADJUST_OPTION";
    /** ADJUST_RUNOFF = 1 */
    public final static String FFG_ADJUST_RUNOFF = "ADJUST_RUNOFF";
    /** USE_FIELDS_AS_FFG = 2 */
    public final static String FFG_USE_FIELDS_AS_FFG = "USE_FIELDS_AS_FFG";
    /** USE_THRESHOLD_RUNOFF_AS_FFG = 3 */
    public final static String FFG_USE_THRESHOLD_RUNOFF_AS_FFG = "USE_THRESHOLD_RUNOFF_AS_FFG";

    public final static String FFG_ADJUST_FLOW_TIME_1_HOUR_TAG = "ADJUST_FLOW_TIME_1_HOUR";
    public final static String FFG_ADJUST_FLOW_TIME_3_HOUR_TAG = "ADJUST_FLOW_TIME_3_HOUR";
    public final static String FFG_ADJUST_FLOW_TIME_6_HOUR_TAG = "ADJUST_FLOW_TIME_6_HOUR";
    public final static String FFG_ADJUST_FLOW_TIME_12_HOUR_TAG = "ADJUST_FLOW_TIME_12_HOUR";
    public final static String FFG_ADJUST_FLOW_TIME_24_HOUR_TAG = "ADJUST_FLOW_TIME_24_HOUR";
    public final static String[] FFG_ADJUST_FLOW_TIME_TAGS = new String[]{FFG_ADJUST_FLOW_TIME_1_HOUR_TAG,
        FFG_ADJUST_FLOW_TIME_3_HOUR_TAG, FFG_ADJUST_FLOW_TIME_6_HOUR_TAG, FFG_ADJUST_FLOW_TIME_12_HOUR_TAG,
        FFG_ADJUST_FLOW_TIME_24_HOUR_TAG};

    public final static String FFG_MIN_MAX_VALUES_1_HOUR_TAG = "MIN_MAX_VALUES_1_HOUR";
    public final static String FFG_MIN_MAX_VALUES_3_HOUR_TAG = "MIN_MAX_VALUES_3_HOUR";
    public final static String FFG_MIN_MAX_VALUES_6_HOUR_TAG = "MIN_MAX_VALUES_6_HOUR";
    public final static String FFG_MIN_MAX_VALUES_12_HOUR_TAG = "MIN_MAX_VALUES_12_HOUR";
    public final static String FFG_MIN_MAX_VALUES_24_HOUR_TAG = "MIN_MAX_VALUES_24_HOUR";
    public final static String[] FFG_MIN_MAX_VALUES_TAGS = new String[]{FFG_MIN_MAX_VALUES_1_HOUR_TAG,
        FFG_MIN_MAX_VALUES_3_HOUR_TAG, FFG_MIN_MAX_VALUES_6_HOUR_TAG, FFG_MIN_MAX_VALUES_12_HOUR_TAG,
        FFG_MIN_MAX_VALUES_24_HOUR_TAG};

    public final static String FFG_USER_CTRL_RFC_ID_TAG = "FFG_USER_CTRL_RFC_ID";
    public final static String FFG_USER_CTRL_WEST_COLUMN_TAG = "FFG_USER_CTRL_WEST_COLUMN";
    public final static String FFG_USER_CTRL_NUMBER_OF_COLUMNS_TAG = "FFG_USER_CTRL_NUMBER_OF_COLUMNS";
    public final static String FFG_USER_CTRL_SOUTHERN_ROW_TAG = "FFG_USER_CTRL_SOUTHERN_ROW";
    public final static String FFG_USER_CTRL_NUMBER_OF_ROWS_TAG = "FFG_USER_CTRL_NUMBER_OF_ROWS";

    public final static String FFG_INTENSITY_1_HOUR_TAG = "FFG_INTENSITY_1_HOUR";
    public final static String FFG_INTENSITY_3_HOUR_TAG = "FFG_INTENSITY_3_HOUR";
    public final static String FFG_INTENSITY_6_HOUR_TAG = "FFG_INTENSITY_6_HOUR";
    public final static String FFG_INTENSITY_12_HOUR_TAG = "FFG_INTENSITY_12_HOUR";
    public final static String FFG_INTENSITY_24_HOUR_TAG = "FFG_INTENSITY_24_HOUR";
    public final static String[] FFG_INTENSITY_TAGS = new String[]{FFG_INTENSITY_1_HOUR_TAG, FFG_INTENSITY_3_HOUR_TAG,
        FFG_INTENSITY_6_HOUR_TAG, FFG_INTENSITY_12_HOUR_TAG, FFG_INTENSITY_24_HOUR_TAG};
    /** -9.8 */
    public final static double FFG_MISSING_VALUE = -9.8;

    public final static String FFG_FORECAST_FLOW_TIMESERIES_ID_TAG = "FFG_FORECAST_FLOW_TIMESERIES_ID";
    public final static String FFG_DATA_TYPE_CODE_OF_FORECAST_FLOW_TIMESERIES_TAG = "FFG_DATA_TYPE_CODE_OF_FORECAST_FLOW_TIMESERIES";
    public final static String FFG_DATA_TIME_INTERVAL_OF_FORECAST_FLOW_TIMESERIES_TAG = "FFG_DATA_TIME_INTERVAL_OF_FORECAST_FLOW_TIMESERIES";

    public final static String THRESHOLD_RUNOFF_1_HR_IN_INCHES_TAG = "THRESHOLD_RUNOFF_1_HR_IN_INCHES";
    public final static String THRESHOLD_RUNOFF_3_HR_IN_INCHES_TAG = "THRESHOLD_RUNOFF_3_HR_IN_INCHES";
    public final static String THRESHOLD_RUNOFF_6_HR_IN_INCHES_TAG = "THRESHOLD_RUNOFF_6_HR_IN_INCHES";
    public final static String THRESHOLD_RUNOFF_12_HR_IN_INCHES_TAG = "THRESHOLD_RUNOFF_12_HR_IN_INCHES";
    public final static String THRESHOLD_RUNOFF_24_HR_IN_INCHES_TAG = "THRESHOLD_RUNOFF_24_HR_IN_INCHES";
    public final static String[] THRESHOLD_RUNOFF_IN_INCHES_TAGS = new String[]{THRESHOLD_RUNOFF_1_HR_IN_INCHES_TAG,
        THRESHOLD_RUNOFF_3_HR_IN_INCHES_TAG, THRESHOLD_RUNOFF_6_HR_IN_INCHES_TAG, THRESHOLD_RUNOFF_12_HR_IN_INCHES_TAG,
        THRESHOLD_RUNOFF_24_HR_IN_INCHES_TAG};

}
