package ohd.hseb.ohdutilities.ffg.griddedFfg;

/**
 * A)for the cases 1-5: (suppose is 2) <br>
 * i)the code extends two extra pixels on the left end of lineseg and two extra pixels on the right end of lineseg. The
 * ffg values of the two new pixels at each end equal to the original end pixel value;<br>
 * ii)adds two extra linesegs on the top and another two extra linesegs at the bottom. The two new linesegs at the top
 * equal to the original top lineseg; the two new linesegs at the bottom equal to the original bottom lineseg.<br>
 * <br>
 * B)for the case 6: Going through every pixel in the whole RFC. If a pixel with missing ffg value has 5 or more than 5
 * pixels with non-negative ffg values(including 0.0), this pixel will be filled with ffg values which is the dominant
 * value among the surrounding pixels. So if this missing pixel has 5 good neighbors(1.1, 1.1, 2.2, 1.1, 2.2), it will
 * be filled with 1.1, since 1.1 is dominant.
 */
public enum GRID_FILL_CONTROL
{
    NO_GRID_FILLING(0), //default case
    FILL_USING_1(1), //
    FILL_USING_2(2), //
    FILL_USING_3(3), //
    FILL_USING_4(4), //
    FILL_USING_5(5), //
    FILL_USING_DOMINANT_NEIGHBOR(6);

    private int _gridFillAsNum = 0;

    private GRID_FILL_CONTROL(final int num)
    {
        _gridFillAsNum = num;
    }

    public static GRID_FILL_CONTROL convertFromNum(final int gridFillAsNumber) throws Exception
    {
        switch(gridFillAsNumber)
        {
            case 0:
                return NO_GRID_FILLING;
            case 1:
                return FILL_USING_1;
            case 2:
                return FILL_USING_2;
            case 3:
                return FILL_USING_3;
            case 4:
                return FILL_USING_4;
            case 5:
                return FILL_USING_5;
            case 6:
                return FILL_USING_DOMINANT_NEIGHBOR;
            default:
                throw new Exception("The parameter " + GriddedFFGConstants.FFG_GRID_FILL_TAG
                    + " value should be 0 to 6. But it is " + gridFillAsNumber);
        }//close switch
    }//close method

    public int getGridFillNumber()
    {
        return _gridFillAsNum;
    }
}
