package ohd.hseb.ohdutilities.ffg.griddedFfg;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.ohdutilities.ffg.FfgConstants;
import ohd.hseb.ohdutilities.ffg.FfgParameters;
import ohd.hseb.util.fews.LineSeg;
import ohd.hseb.util.fews.ParameterType.Row;
import ohd.hseb.util.fews.ParameterType.Table;

public class GriddedFFGParameters extends FfgParameters
{
    private int _gridFillControlAsNum = GRID_FILL_CONTROL.NO_GRID_FILLING.getGridFillNumber(); //default

    private double _bank = 0.0; //default

    private List<LineSeg>[] _gridThreshRunoffListArray; //an array of List

    /**
     * Called during parsing input/paramsFFH.xml, OHDFewsAdapter.defineModelRunInfoAndSetupModel() method.
     */
    @Override
    protected void extractValuesFromMap() throws Exception
    {
        super.extractValuesFromMapFFG();

        final String ffgAreaId = _ffgLocationId;
        _ffgAreaIdArray = new String[]{ffgAreaId}; //Gridded FFG only has one area
        /*
         * Gridded FFG only has one area and the area Id is same as the location id.(FFH location id is different from
         * area id, even when it only has one area)
         */

        //get the FFG Duration
        final String durStr = super.getStringDataParameter(ffgAreaId, FfgConstants.FFG_DURATION_TAG);

        //now set model interval array
        super.setModelDurationInterval(durStr);

        if(isParamExisting(GriddedFFGConstants.FFG_OVERBANK_FACTOR_TAG))
        {
            _bank = getDoubleDataParameter(GriddedFFGConstants.FFG_OVERBANK_FACTOR_TAG);
        }

        if(_bank < 0.6 || _bank > 1.5)
        {
            _bank = getDoubleDataParameter(GriddedFFGConstants.FFG_USER_CTRL_GBANK_FACTOR_TAG); //User Ctrl always exists
        }

        _gridThreshRunoffListArray = new List[_modelIntervalArray.length];

        for(int i = 0; i < _gridThreshRunoffListArray.length; i++)
        {
            _gridThreshRunoffListArray[i] = new ArrayList<LineSeg>();
        }

        for(int i = 0; i < _modelIntervalArray.length; i++)
        {
            final Table ffgThresholdRunoffTable = super.getTableDataParameter(FfgConstants.THRESHOLD_RUNOFF_IN_INCHES_TAGS[i]);

            if(ffgThresholdRunoffTable != null && ffgThresholdRunoffTable.getRow() != null)
            {
                List<Row> rowList = new ArrayList<Row>();

                for(final Row myRow: ffgThresholdRunoffTable.getRow())
                {

                    if(rowList.size() == 0)
                    {
                        rowList.add(myRow);

                    }
                    else if(Integer.valueOf(myRow.getA()).intValue() == Integer.valueOf(rowList.get(0).getA())
                                                                               .intValue())
                    {//myRow is the same lineseg as previous rows
                        rowList.add(myRow);
                    }
                    else
                    {//myRow belongs to the next lineseg. So the current lineseg has all the rows already. 

                        final LineSeg lineSeg = new LineSeg(rowList);

                        _gridThreshRunoffListArray[i].add(lineSeg);

                        //starting a new rowList for next lineseg
                        rowList = new ArrayList<Row>();

                        rowList.add(myRow);
                    }

                } //close for loop

                final LineSeg lineSeg = new LineSeg(rowList); //"rowList" contains the rows of last line seg obj.

                _gridThreshRunoffListArray[i].add(lineSeg);
            }

        } //close for loop

        if(isParamExisting(GriddedFFGConstants.FFG_GRID_FILL_TAG))
        {
            final String gridFillAsString = getStringDataParameter(GriddedFFGConstants.FFG_GRID_FILL_TAG);
            _gridFillControlAsNum = GRID_FILL_CONTROL.valueOf(gridFillAsString).getGridFillNumber();
        }

    } //close method

    /**
     * Returns an array of Lists. The 1st element of the array is for 1 hour model duration; the 2nd element of the
     * array is for 3 hour model duration, etc.
     */
    List<LineSeg>[] getGridThreshRunoffListArray()
    {
        return _gridThreshRunoffListArray;
    }

    double getBank()
    {
        return _bank;
    }

    /**
     * Returns an double array holding two elements: first is the minimal value of ffg, second is the max value of ffg.
     * Unit is inch. One min - max pair for one model duration.
     * 
     * @throws Exception
     */
    double[] getMinMaxValues(final int durationIndex) throws Exception
    {
        double minValue = 0.0; //unit INCH
        double maxValue = 0.0; //unit INCH

        final Table ffhMaxMinValuesTable = super.getTableDataParameter(FfgConstants.FFG_MIN_MAX_VALUES_TAGS[durationIndex]);
        if(ffhMaxMinValuesTable != null && ffhMaxMinValuesTable.getRow() != null)
        {
            final Row row = ffhMaxMinValuesTable.getRow().get(0);

            minValue = Double.valueOf(row.getA());
            maxValue = Double.valueOf(row.getB());
        }

        return new double[]{minValue, maxValue};
    }

    int getGridFillControlAsNum()
    {
        return _gridFillControlAsNum;
    }
}
