package ohd.hseb.ohdutilities.ffg.model.rainfall;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.Parameters;
import ohd.hseb.util.fews.RunInfo;
import ohd.hseb.util.fews.State;

public abstract class FFGRainfallRunoffModel
{

    protected Parameters _rainFallRunoffParam;

    protected State _state;

    protected RunInfo _runInfo;

    protected Logger _logger;

    /**
     * Return runoff in unit of MM.
     * 
     * @param precipAmount - unit of MM
     */
    public abstract double getRunoff(final double precipAmount, final int modelTimeInterval) throws Exception;

}
