package ohd.hseb.ohdutilities.prodgen;

public class TextProductGeneratorConstants
{
    //TEXT parameters in params.xml
    public final static String TEXT_PRODGEN_TAG = "TEXT_PRODGEN";

    //PRODUCT parameters in params.xml
    public final static String PROD_PRODGEN_TAG = "PROD_PRODGEN";

    //SETUP parameters in params.xml including the location id, headwater name and stream name
    public final static String LID_HNAME_SNAME_PRODGEN_TAG = "LID_HNAME_SNAME_PRODGEN";
    public final static String LID_HNAME_SNAME_TABLE_TAG = "LID_HNAME_SNAME_TABLE";
    public final static String PRODGEN_LOCATION_ID_TAG = "PRODGEN_LOCATION_ID";
    public final static String PRODGEN_HEADWATER_NAME_TAG = "PRODGEN_HEADWATER_NAME";
    public final static String PRODGEN_STREAM_NAME_TAG = "PRODGEN_STREAM_NAME";

    //DUTY FORECASTOR parameters in params.xml including the flag, forecaster initial and full name
    public final static String FORECASTER_PRODGEN_GROUP_TAG = "FORECASTER_PRODGEN";
    public final static String FORECASTER_DUTY_FLAG_TAG = "FORECASTER_DUTY_FLAG";
    public final static String FORECASTER_TABLE_TAG = "FORECASTER_TABLE";
    public final static String PRODGEN_FORECASTER_INT_TAG = "PRODGEN_FORECASTER_INT";
    public final static String PRODGEN_FORECASTER_NAME_TAG = "PRODGEN_FORECASTER_NAME";

    //AREAL/ZONE parameters in params.xml
    public final static String LID_ZONE_PRODGEN_TAG = "LID_ZONE_PRODGEN";
    public final static String LID_ZONE_TABLE_TAG = "LID_ZONE_TABLE";
    public final static String PRODGEN_LOC_ID_TAG = "PRODGEN_LOC_ID";
    public final static String PRODGEN_ZONE_NAME_TAG = "PRODGEN_ZONE_NAME";

    //other constants
    public final static double MISSING_VALUE = -9.8;
    public final static int PROD_REQUIRED_FIELDS = 12;
    public final static int PROD_STR_LEN = 4;
    public final static int PROD_NAME_LEN = 6;
    public final static int PROD_FORMAT_LEN = 4;
    public final static int PROD_TYPE_LEN = 4;
    public final static int PROD_ID_MAXLEN = 9;
    public final static int PROD_CIRCUITS_MAXLEN = 3;
    public final static int PROD_WMO_LEN = 6;
    public final static int PROD_OFFICE_LEN = 4;
    public final static int PROD_TZ_LEN = 1;
    public final static int PROD_DESCRIPTION_LEN = 1;
    public final static int PROD_STREAMNAME_LEN = 1;
    public final static String PROD_LONGEST_DUR1 = "1";
    public final static String PROD_LONGEST_DUR3 = "3";
    public final static String PROD_LONGEST_DUR6 = "6";
    public final static String PROD_LONGEST_DUR12 = "12";
    public final static String PROD_LONGEST_DUR24 = "24";
    public final static String PROD_MINUTES_DUR1 = "60";
    public final static String PROD_MINUTES_DUR3 = "180";
    public final static String PROD_MINUTES_DUR6 = "360";
    public final static String PROD_MINUTES_DUR12 = "720";
    public final static String PROD_MINUTES_DUR24 = "1440";
    public final static String TEXT_DOTB_TAG = "DOTB";
    public final static String TEXT_ISSUED_TAG = "ISSUED";
    public final static String TEXT_LABL_TAG = "LABL";
    public final static String TEXT_LABLHEAD_TAG = "LABLHEAD";
    public final static String TEXT_SKIPLINE_TAG = "SKIPLINE";
    public final static String TEXT_ENDTEXT_TAG = "ENDTEXT";
    public final static String TEXT_NWS_TAG = "NATIONAL WEATHER SERVICE";
    public final static String ONEHR_LABLE_TITLE = ":IDENT    1HR";
    public final static String THREEHR_LABLE_TITLE = ":IDENT    1HR   3HR";
    public final static String SIXHR_LABLE_TITLE = ":IDENT    1HR   3HR   6HR";
    public final static String TWELVEHR_LABLE_TITLE = ":IDENT    1HR   3HR   6HR  12HR";
    public final static String TWENTYFOUR_LABLE_TITLE = ":IDENT    1HR   3HR   6HR  12HR  24HR";
    public final static String HEADWATER_LABLE_TITLE = "HEADWATER NAME";
    public final static String ZONE_LABLE_TITLE = "ZONE NAME";
    public final static String STREAM_LABLE_TITLE = "STREAM";
    public final static String ONEHR_LABLE_SYMBOL = ":======= ====";
    public final static String THREEHR_LABLE_SYMBOL = ":======= ====  ====";
    public final static String SIXHR_LABLE_SYMBOL = ":======= ====  ====  ====";
    public final static String TWELVEHR_LABLE_SYMBOL = ":======= ====  ====  ====  ====";
    public final static String TWENTYFOURHR_LABLE_SYMBOL = ":======= ====  ====  ====  ====  ====";
    public final static String HEADWATER_LABLE_SYMBOL = "====================";
    public final static String STREAM_LABLE_SYMBOL = "==================";
    public final static String FORECASTER_NOT_INCLUDE_TAG = "FORECASTER_NOT_INCLUDE";
    public final static String INCLUDE_OFFICE_TAG = "INCLUDE_OFFICE";
    public final static String INCLUDE_FORECASTER_TAG = "INCLUDE_FORECASTER";
    public final static String INCLUDE_OFFICE_FORECASTER_TAG = "INCLUDE_OFFICE_FORECASTER";
    public final static String COMMS_AWIPS_TAG = "COMMS_AWIPS";
    public final static String COMMS_AFOS_TAG = "COMMS_AFOS";
    public final static String COMMS_HEADER_END_TAG = "COMMS_HEADER_END";
    public final static String SIXHR_PP_TAG = "/PPHCF/PPTCF/PPQCF";
    public final static String SIXHR_PF_TAG = "/PFH/PFT/PFQ";
    public final static String TWELVEHR_PP_TAG = "/PPHCF/PPTCF/PPQCF/PPKCF";
    public final static String TWELVEHR_PF_TAG = "/PFH/PFT/PFQ/PFK";
    public final static String TWENTYFOUR_PP_TAG = "/PPHCF/PPTCF/PPQCF/PPKCF/PPDCF";
    public final static String TWENTYFOUR_PF_TAG = "/PFH/PFT/PFQ/PFK/PFD";
    public final static String GROUP_PRODUCT_PRODGEN_TAG = "GROUP_PRODUCT_PRODGEN";
    public final static String GROUP_PRODUCT_OUTPUT_FILE_TAG = "GROUP_PRODUCT_OUTPUT_FILE";
    public final static String ONE_PRODUCT_PER_FILE_TAG = "ONE_PRODUCT_PER_FILE";
    public final static String ALL_PRODUCT_ONE_FILE_TAG = "ALL_PRODUCT_ONE_FILE";
    public final static String PHYSICAL_ELEMENTS_TAG = "PHYSICAL_ELEMENTS";
    public final static String PF_PHYSICAL_ELEMENTS_TAG = "PF_PHYSICAL_ELEMENTS";
    public final static String PP_PHYSICAL_ELEMENTS_TAG = "PP_PHYSICAL_ELEMENTS";
    public final static String YEAR_DATE_FORMAT_TAG = "YEAR_DATE_FORMAT";
    public final static String YY_DATE_FORMAT_TAG = "YY_DATE_FORMAT";
    public final static String YYYY_DATE_FORMAT_TAG = "YYYY_DATE_FORMAT";
    public final static String PRODUCT_PREFIX_TAG = "PRODUCT_";
    //for GRIB1 format
    public final static String GRIBPRODUCT = "GRIB";
    public final static String SHEFPRODUCT = "SHEF";
    public final static String FFHPRODUCT = "HFFG";
    public final static String FFGPRODUCT = "AFFG";
    public final static String GRIBFFGPRODUCT = "GFFG";

    public final static String ENDID_TAG = "ENDID";
    public final static String RUN_INFO_GROUPID_TAG = "groupId";

    public final static String FFGGRIBPRODUCT_EXE_NAME = "ffgGribProduct";
    public final static String INPUTNETCDFFILE = "inputNetcdfFile";
    public final static String OUTPUTGRIB1FILEPREF = "outputGrib1FilePref";
    public final static String DIAGFILENAME = "diagFileName";
    public final static String DEBUGFLAG = "debugFlag";
    public final static String SITEID = "siteId";
    public final static String WMOID = "wmoId";
    public final static String PROCESSID = "processId";
    public final static String COMPUTATIONYEAR = "computationYear";
    public final static String COMPUTATIONMON = "computationMon";
    public final static String COMPUTATIONDAY = "computationDay";
    public final static String COMPUTATIONHRMIN = "computationHrMin";
    public final static String FORECASTTIMEUNIT = "forecastTimeUnit";
    public final static String TIMERANGEINDICATOR = "timeRangeIndicator";
    public final static String SUBCENTERID = "subCenterId";
    public final static String DECIMALSCALEFACTOR = "decimalScaleFactor";
    public final static String PROJECTIONTYPE = "projectionType";
    public final static String FFG_PROCESSID_VAL = "151";
    public final static String FFG_FORECASTTIMEUNIT_VAL = "1";
    public final static String FFG_TIMERANGINDICATOR_VAL = "2";
    public final static String FFG_SUBCENTERID_VAL = "158";
    public final static String FFG_DECIMALSCALEFACTOR_VAL = "0";
    public final static String PROJECTIONTYPE_VAL = "32";
    /** 1 **/
    public final static String MCF_GROUP_FFHONLY_TEMPLATE = "Prodgen_GROUP_FFHONLY_template.xml";
    /** 2 **/
    public final static String MCF_GROUP_FFGONLY_TEMPLATE = "Prodgen_GROUP_FFGONLY_template.xml";
    /** 3 **/
    public final static String MCF_GROUP_GRIBONLY_TEMPLATE = "Prodgen_GROUP_GRIBONLY_template.xml";
    /** 4 **/
    public final static String MCF_GROUP_FFHFFG_TEMPLATE = "Prodgen_GROUP_FFHFFG_template.xml";
    /** 5 **/
    public final static String MCF_GROUP_FFHGRIB_TEMPLATE = "Prodgen_GROUP_FFHGRIB_template.xml";
    /** 6 **/
    public final static String MCF_GROUP_FFGGRIB_TEMPLATE = "Prodgen_GROUP_FFGGRIB_template.xml";
    /** 7 **/
    public final static String MCF_GROUP_FFHFFGGRIB_TEMPLATE = "Prodgen_GROUP_FFHFFGGRIB_template.xml";

    public final static String PARAMETER_CONFIG_FILE_DIR = "ModuleParFiles/prodgen";
    public final static String MODULE_CONFIG_FILE_DIR = "ModuleConfigFiles/prodgen";
    public final static String REGION_CONFIG_FILE_DIR = "RegionConfigFiles";
    public final static String WORKFLOW_CONFIG_FILE_DIR = "WorkflowFiles/prodgen";
    public final static String WORKFLOW_DESCRIPTOR_FILE_NAME = "WorkflowDescriptors.xml";
    public final static String MODULE_INSTANCE_DESCRIPTOR_FILE_NAME = "ModuleInstanceDescriptors.xml";
    public final static String PARAMETER_CONFIG_INSTANCE_ID = "ProdgenFFHFFG_PARAMS";
    public final static String PARAMETER_CONFIG_FILE_NAME = "ProdgenFFHFFG_PARAMS.xml";
    public final static String TOPOLOGY_FILE_NAME = "Topology.xml";

}
