package ohd.hseb.ohdutilities.prodgen;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ohdutilities.UtilityParameters;

/**
 * retrieve the 12 required data fields for a specified product id
 * 
 * @author dengj
 */
public class TextProductGeneratorProcessProd extends UtilityParameters
{
    //variables
    private String _prodValue;
    private String _prodStr;
    private String _prodName;
    private String _prodFormat;
    private String _prodType;
    private String _prodId;
    private String _prodCircuits;
    private String _prodWmo;
    private String _prodOffice;
    private String _prodTz;
    private String _prodLongestDur;
    private String _prodDescriptionFlag;
    private String _prodStreamNameFlag;

    //   private Map<String, String> _prodMap;
    private List<TextProductGeneratorIdValue> _prodIdValuePair = new ArrayList<TextProductGeneratorIdValue>();

    /**
     * constructors
     */
    public TextProductGeneratorProcessProd()
    {
        super();
    }

    public TextProductGeneratorProcessProd(final String prodValue)
    {
        _prodValue = prodValue;

    }

    public String get_prodCircuits()
    {
        return _prodCircuits;
    }

    public String get_prodDescriptionFlag()
    {
        return _prodDescriptionFlag;
    }

    public String get_prodFormat()
    {
        return _prodFormat;
    }

    public String get_prodId()
    {
        return _prodId;
    }

    public List<TextProductGeneratorIdValue> get_prodIdValuePair()
    {
        return _prodIdValuePair;
    }

    public String get_prodLongestDur()
    {
        return _prodLongestDur;
    }

    public String get_prodName()
    {
        return _prodName;
    }

    public String get_prodOffice()
    {
        return _prodOffice;
    }

    public String get_prodStr()
    {
        return _prodStr;
    }

    public String get_prodStreamNameFlag()
    {
        return _prodStreamNameFlag;
    }

    public String get_prodType()
    {
        return _prodType;
    }

    public String get_prodTz()
    {
        return _prodTz;
    }

    public String get_prodValue()
    {
        return _prodValue;
    }

    public String get_prodWmo()
    {
        return _prodWmo;
    }

    /**
     * print error message
     * 
     * @param errorSegment
     * @throws Exception
     */
    public void printErrorMessage(final String errorSegment) throws Exception
    {
        this._logger.log(Logger.ERROR, "- Invalid mandatory field - " + errorSegment);
        throw new Exception("Error:" + getClass().getName() + "-Invalid mandatory field - " + errorSegment);

    }

    /**
     * retrieve the 12 required data fields for the specified product id
     * 
     * @throws Exception
     */
    public void processProd() throws Exception
    {
        final String delimiter = " \n";
        final StringTokenizer prodTokenizer = new StringTokenizer(_prodValue, delimiter);
        final List<String> prodSegments = new ArrayList<String>();

        //given string will be split by delimiter provided.

        //get required fields
        if(prodTokenizer != null)
        {
            while(prodTokenizer.hasMoreTokens())
            {
                prodSegments.add(prodTokenizer.nextToken());
            }
        }
//        else
//        {
//            if (_logger.getPrintDebugInfo()>0)
//            {
//                _logger.log(Logger.DEBUG, "Not enough mandatory fields");
//            }
//        }
        if(prodSegments.size() >= TextProductGeneratorConstants.PROD_REQUIRED_FIELDS)
        {
            if(prodSegments.get(0).length() == TextProductGeneratorConstants.PROD_STR_LEN)
            {
                _prodStr = prodSegments.get(0); //wording e.g. "prod"
            }
            else
            {
                printErrorMessage(prodSegments.get(0));
            }

            _prodName = prodSegments.get(1); //product name e.g. "FFHORN"

            if(prodSegments.get(2).length() == TextProductGeneratorConstants.PROD_FORMAT_LEN)
            {
                _prodFormat = prodSegments.get(2); //product format e.g. "SHEF"
            }
            else
            {
                printErrorMessage(prodSegments.get(2));
            }

            if(prodSegments.get(3).length() == TextProductGeneratorConstants.PROD_TYPE_LEN)
            {
                _prodType = prodSegments.get(3); //product default type e.g. "HFFG"
            }
            else
            {
                printErrorMessage(prodSegments.get(3));
            }

            if(prodSegments.get(4).length() <= TextProductGeneratorConstants.PROD_ID_MAXLEN)
            {
                _prodId = prodSegments.get(4); //product ID e.g. "NEWFFHORN"

                if(_prodId.length() < TextProductGeneratorConstants.PROD_ID_MAXLEN)
                {
                    _prodId = _prodId.concat(" ");
                }
            }
            else
            {
                printErrorMessage(prodSegments.get(4));
            }

            if(prodSegments.get(5).length() <= TextProductGeneratorConstants.PROD_CIRCUITS_MAXLEN)
            {
                _prodCircuits = prodSegments.get(5); //product Circuits e.g. "ORN"
            }
            else
            {
                printErrorMessage(prodSegments.get(5));
            }

            if(prodSegments.get(6).length() == TextProductGeneratorConstants.PROD_WMO_LEN)
            {
                _prodWmo = prodSegments.get(6); //WMO header e.g. "TTAAOO"
            }
            else
            {
                printErrorMessage(prodSegments.get(6));
            }

            if(prodSegments.get(7).length() <= TextProductGeneratorConstants.PROD_OFFICE_LEN)
            {
                _prodOffice = prodSegments.get(7); //Sending office e.g. "KORN"
            }
            else
            {
                printErrorMessage(prodSegments.get(7));
            }

            if(prodSegments.get(8).length() == TextProductGeneratorConstants.PROD_TZ_LEN)
            {
                _prodTz = prodSegments.get(8); //time zone e.g. "C"
            }
            else
            {
                printErrorMessage(prodSegments.get(8));
            }

            _prodLongestDur = prodSegments.get(9); //longest duration e.g. 24

            if(prodSegments.get(10).length() == TextProductGeneratorConstants.PROD_DESCRIPTION_LEN)
            {
                _prodDescriptionFlag = prodSegments.get(10); //product description flag "0" as no, "1" as yes
            }
            else
            {
                printErrorMessage(prodSegments.get(10));
            }

            if(prodSegments.get(11).length() == TextProductGeneratorConstants.PROD_STREAMNAME_LEN)
            {
                _prodStreamNameFlag = prodSegments.get(11); //product stream name flag "0" as no, "1" as yes
            }
            else
            {
                printErrorMessage(prodSegments.get(11));
            }

        }

        else
        {
            _logger.log(Logger.ERROR, getClass().getName() + "- Not enough required fields.");
            throw new Exception("Error:" + getClass().getName() + "- Not enough required fields.");
        }

        for(int i = TextProductGeneratorConstants.PROD_REQUIRED_FIELDS; i < prodSegments.size() - 1; i += 2)
        {
            _prodIdValuePair.add(new TextProductGeneratorIdValue(prodSegments.get(i), prodSegments.get(i + 1)));

        }

    }

    public void set_prodCircuits(final String circuits)
    {
        _prodCircuits = circuits;
    }

    public void set_prodDescriptionFlag(final String descriptionFlag)
    {
        _prodDescriptionFlag = descriptionFlag;
    }

    public void set_prodFormat(final String format)
    {
        _prodFormat = format;
    }

    public void set_prodId(final String id)
    {
        _prodId = id;
    }

    public void set_prodIdValuePair(final List<TextProductGeneratorIdValue> idValuePair)
    {
        _prodIdValuePair = idValuePair;
    }

    public void set_prodLongestDur(final String longestDur)
    {
        _prodLongestDur = longestDur;
    }

    public void set_prodName(final String name)
    {
        _prodName = name;
    }

    public void set_prodOffice(final String office)
    {
        _prodOffice = office;
    }

    public void set_prodStr(final String str)
    {
        _prodStr = str;
    }

    public void set_prodStreamNameFlag(final String streamNameFlag)
    {
        _prodStreamNameFlag = streamNameFlag;
    }

    public void set_prodType(final String type)
    {
        _prodType = type;
    }

    public void set_prodTz(final String tz)
    {
        _prodTz = tz;
    }

    public void set_prodValue(final String value)
    {
        _prodValue = value;
    }

    public void set_prodWmo(final String wmo)
    {
        _prodWmo = wmo;
    }
}