package ohd.hseb.ohdutilities.sshp.sshpChpsExtractor;

import ohd.hseb.ohdmodels.sacsma.SacSmaModelConstants;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

/**
 * This class holds all the SAC-SMA Model parameters. It is a subclass of {@link ModelParameters} and interface
 * {@link IModelParameters}. They are specified in the opt file:
 * <p>
 * <ul>
 * <li>Card #1,
 * <li>Card #2(could be completely blank),
 * <li>Card #3,
 * <li>Card #4,
 * <li>Card #5,
 * <li>Card #F1,(F1 and F2 are for FRZE)
 * <li>Card #F2
 * </ul>
 * Values are initially loaded into super._parasmMap, then extracted into instance variables to avoid frequent accessing
 * the Map. Setter methods are not needed, since the model does not change parameters. All values in METRIC unit.
 * <p>
 * {@link SacSmaOptFileConverter} sets the parameter values by using various insertParameter(..) methods in
 * {@link ModelParameters}.
 * 
 * @author FewsPilot Team
 */
final public class SshpChpsExtractorParameters extends ModelParameters
{

    //these Tags are used by sacsmaHT project and nwsrfsadapter, that is the only reason this class be public
    final static String PXADJ_TAG = "PXADJ";
    private double _pxadj;
    final static String RSERV_TAG = "RSERV";
    private double _rserv;
    final static String SIDE_TAG = "SIDE";
    private double _side;
    final static String PFREE_TAG = "PFREE";
    private double _pfree;
    final static String LZPK_TAG = "LZPK";
    private double _lzpk;
    final static String LZSK_TAG = "LZSK";
    private double _lzsk;
    final static String EFC_TAG = "EFC";
    private double _efc;
    final static String REXP_TAG = "REXP";
    private double _rexp;
    final static String ZPERC_TAG = "ZPERC";
    private double _zperc;
    final static String RIVA_TAG = "RIVA";
    private double _riva;
    final static String ADIMP_TAG = "ADIMP";
    private double _adimp;
    final static String PCTIM_TAG = "PCTIM";
    private double _pctim;
    final static String UZK_TAG = "UZK";
    private double _uzk;
    private double[] _ett;
    //if not using MAPE input ts(default case), the 12 values are ET-demand; if using MAPE ts, these values are PE-adjustment
    final static String LZFPM_TAG = "LZFPM";
    private double _lzfpm;
    final static String LZFSM_TAG = "LZFSM";
    private double _lzfsm;
    final static String LZTWM_TAG = "LZTWM";
    private double _lztwm;
    final static String UZFWM_TAG = "UZFWM";
    private double _uzfwm;
    final static String PEADJ_TAG = "PEADJ";
    private double _peadj;
    final static String UZTWM_TAG = "UZTWM";
    private double _uztwm;
    private boolean _useMAPEInput = false; //default is NO

    //card F1 - skip

    //card F2 - skip

    //card F3 are Model State

    /**
     * Instantiates a new sacsma model parameters. Values are set by parsing params.xml file by FewsXMLParser.java(in
     * package ohdfewsadapter) method public void parseParameters(final String paramFileName).
     */
    SshpChpsExtractorParameters()
    {
       super();
    }

    /**
     * Extract values from super._parametersMap into instance variables. The values in super._parametersMap are set by
     * parsing parameter xml file in OHDFewsAdapter.java.
     * 
     * @throws Exception
     */
    @Override
    protected void extractValuesFromMap() throws Exception
    {
        _pxadj = getDoubleDataParameter(PXADJ_TAG);

        _peadj = getDoubleDataParameter(PEADJ_TAG);

        _uztwm = getDoubleDataParameter(UZTWM_TAG);

        _uzfwm = getDoubleDataParameter(UZFWM_TAG);

        _uzk = getDoubleDataParameter(UZK_TAG);

        _pctim = getDoubleDataParameter(PCTIM_TAG);

        _adimp = getDoubleDataParameter(ADIMP_TAG);

        _riva = getDoubleDataParameter(RIVA_TAG);

        _zperc = getDoubleDataParameter(ZPERC_TAG);

        _rexp = getDoubleDataParameter(REXP_TAG);

        _lztwm = getDoubleDataParameter(LZTWM_TAG);

        _lzfsm = getDoubleDataParameter(LZFSM_TAG);

        _lzfpm = getDoubleDataParameter(LZFPM_TAG);

        _lzsk = getDoubleDataParameter(LZSK_TAG);

        _lzpk = getDoubleDataParameter(LZPK_TAG);

        _pfree = getDoubleDataParameter(PFREE_TAG);

        _rserv = getDoubleDataParameter(RSERV_TAG);

        _side = getDoubleDataParameter(SIDE_TAG);

        _efc = getDoubleDataParameter(EFC_TAG);

        if(super.isParamExisting(SacSmaModelConstants.ET_DEMAND_CURVE_TAG))
        {
            _ett = super.getDoubleArrayParameter(SacSmaModelConstants.ET_DEMAND_CURVE_TAG);
        }
        else
        {
            //extract ett array from super._paramsMap
            _ett = new double[OHDConstants.NUMBER_OF_MONTHS_IN_YEAR];

            for(int i = 0; i < _ett.length; i++)
            {
                switch(i)
                {
                    case 0:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTJAN_TAG);
                        break;
                    case 1:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTFEB_TAG);
                        break;
                    case 2:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTMAR_TAG);
                        break;
                    case 3:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTAPR_TAG);
                        break;
                    case 4:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTMAY_TAG);
                        break;
                    case 5:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTJUN_TAG);
                        break;
                    case 6:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTJUL_TAG);
                        break;
                    case 7:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTAUG_TAG);
                        break;
                    case 8:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTSEP_TAG);
                        break;
                    case 9:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTOCT_TAG);
                        break;
                    case 10:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTNOV_TAG);
                        break;
                    case 11:
                        _ett[i] = getDoubleDataParameter(SacSmaModelConstants.ETTDEC_TAG);
                        break;
                    default:
                        //should not reach here
                        _ett[i] = 0.0;
                        break;
                } //close switch loop

                System.out.println("ett[" + i + "] = " + _ett[i]);
            } //close for loop

        }// close else loop

        if(super.isParamExisting(SacSmaModelConstants.MAPE_INPUT_TAG))
        {
            _useMAPEInput = getBooleanDataParameter(SacSmaModelConstants.MAPE_INPUT_TAG);
        }

    } //close extractValuesFromMap()

    /**
     * @return the _adimp
     */
    double getAdimp()
    {
        return _adimp;
    }

    /**
     * @return the _efc
     */
    double getEfc()
    {
        return _efc;
    }

    /**
     * @return the _lzfpm
     */
    double getLzfpm()
    {
        return _lzfpm;
    }

    /**
     * @return the _lzfsm
     */
    double getLzfsm()
    {
        return _lzfsm;
    }

    /**
     * @return the _lzpk
     */
    double getLzpk()
    {
        return _lzpk;
    }

    /**
     * @return the _lzsk
     */
    double getLzsk()
    {
        return _lzsk;
    }

    /**
     * @return the _lztwm
     */
    double getLztwm()
    {
        return _lztwm;
    }

    /**
     * @return the _pctim
     */
    double getPctim()
    {
        return _pctim;
    }

    /**
     * @return the _peAdj
     */
    double getPeAdj()
    {
        return _peadj;
    }

    /**
     * @return the _pfree
     */
    double getPfree()
    {
        return _pfree;
    }

    /**
     * @return the _pxAdj
     */
    double getPxAdj()
    {
        return _pxadj;
    }

    /**
     * @return the _rexp
     */
    double getRexp()
    {
        return _rexp;
    }

    /**
     * @return the _riva
     */
    double getRiva()
    {
        return _riva;
    }

    /**
     * @return the _rserv
     */
    double getRserv()
    {
        return _rserv;
    }

    /**
     * @return the _side
     */
    double getSide()
    {
        return _side;
    }

    /**
     * @return the _uzfwm
     */
    double getUzfwm()
    {
        return _uzfwm;
    }

    /**
     * @return the _uzk
     */
    double getUzk()
    {
        return _uzk;
    }

    /**
     * @return the _uztwm
     */
    double getUztwm()
    {
        return _uztwm;
    }

    /**
     * @return the _zperc
     */
    double getZperc()
    {
        return _zperc;
    }

    /**
     * See comments on {@link #useMAPEInput()}.
     */
    double[] getEtDemand()
    {
        return _ett;
    }

    /**
     * Default is false, which means that MAPE ts is not used and etDemand 12 values represent ET-demand 16th of each
     * month, daily values are computed by linear interpolation; In the condition of true, etDemand 12 values becomes
     * PE-adjustment factor for the input MAPE ts
     */
    boolean useMAPEInput()
    {
        return _useMAPEInput;
    }

    void setUseMAPEInput(final boolean useMAPEInput)
    {
        _useMAPEInput = useMAPEInput;
    }
}

