package ohd.hseb.ohdutilities.sshp.sshpChpsExtractor;


import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.Parameters;
import ohd.hseb.util.fews.ohdmodels.ModelState;
import ohd.hseb.util.fews.ohdutilities.UtilityState;

/**
 * This class holds all the SacSma Model state variables. It is a subclass of the abstract class ModelState and
 * interface IModelState. The state variable values are loaded from a text file with properties format through
 * {@link #loadState(String, Logger)}. The values are are initially loaded into the Map<String, Object> _statesMap in
 * ModelState, then the values are extracted to the corresponding instance variables.
 * 
 * @author CHPS
 */
final public class SshpChpsExtractorStates extends UtilityState
{
    private double _uztwc;
    private double _uzfwc;
    private double _lztwc;
    private double _lzfsc;
    private double _lzfpc;
    private double _adimc;

    /**
     * Default constructor. All the values in _statesMap are set by {@link ModelState#loadState(String, Logger)}.
     */
    public SshpChpsExtractorStates()
    {
    	super();
    }

    /**
     * Extract values from super._statesMap into instance variables. The values in super._statessMap are set by parsing
     * the initial state file in OHDFewsAdapter.java.
     */
    @Override
    public void extractValuesFromMap() throws Exception
    {
        _uztwc = getDoubleDataState(OHDConstants.SAC_STATE_UZTWC);

        _uzfwc = getDoubleDataState(OHDConstants.SAC_STATE_UZFWC);

        _lztwc = getDoubleDataState(OHDConstants.SAC_STATE_LZTWC);

        _lzfsc = getDoubleDataState(OHDConstants.SAC_STATE_LZFSC);

        _lzfpc = getDoubleDataState(OHDConstants.SAC_STATE_LZFPC);
        
        _adimc = getDoubleDataState(OHDConstants.SAC_STATE_ADIMC);
    }

    /**
     * Validate all required states are present. Confirm input unit is METRIC.
     */
    public void validateState(final Parameters params) throws Exception
    {
        final SshpChpsExtractorParameters sacModelParams = (SshpChpsExtractorParameters)params;

//        confirmUnitMetric();
        
        /** -------------modify states as in fckco1.f ------------------ */
        if(getUztwc() > sacModelParams.getUztwm())
        {
            setUztwc(sacModelParams.getUztwm());
        }

        if(getUzfwc() > sacModelParams.getUzfwm())
        {
            setUzfwc(sacModelParams.getUzfwm());
        }

        if(getLztwc() > sacModelParams.getLztwm())
        {
            setLztwc(sacModelParams.getLztwm());
        }

        if(getLzfsc() > sacModelParams.getLzfsm())
        {
            setLzfsc(sacModelParams.getLzfsm());
        }

        if(getLzfpc() > sacModelParams.getLzfpm())
        {
            setLzfpc(sacModelParams.getLzfpm());
        }

        if(getAdimc() > (sacModelParams.getUztwm() + sacModelParams.getLztwm()))
        {
            setAdimc(sacModelParams.getUztwm() + sacModelParams.getLztwm());
        }

        if(getAdimc() < getUztwc())
        {
            setAdimc(getUztwc());
        }

    } //close validateState()

    /**
     * Over-written the super class method. This method is used to output states into the generated state txt file. The
     * units are always in METRIC.
     */
    @Override
    protected String getStringsFromState()
    {
        final StringBuilder resultStr = new StringBuilder();

        resultStr.append(OHDConstants.SAC_STATE_ADIMC + "=" + _adimc + OHDConstants.NEW_LINE);
        resultStr.append(OHDConstants.SAC_STATE_LZFPC + "=" + _lzfpc + OHDConstants.NEW_LINE);
        resultStr.append(OHDConstants.SAC_STATE_LZFSC + "=" + _lzfsc + OHDConstants.NEW_LINE);
        resultStr.append(OHDConstants.SAC_STATE_LZTWC + "=" + _lztwc + OHDConstants.NEW_LINE);
        resultStr.append(OHDConstants.SAC_STATE_UZFWC + "=" + _uzfwc + OHDConstants.NEW_LINE);
        resultStr.append(OHDConstants.SAC_STATE_UZTWC + "=" + _uztwc + OHDConstants.NEW_LINE);

        resultStr.append(OHDConstants.UNIT_TAG + "=" + OHDConstants.UNIT_METRIC + OHDConstants.NEW_LINE);
        //units are in METRIC always

        return resultStr.toString();
    }

    void setUztwc(final double uztwc)
    {
        _uztwc = uztwc;
    }

    double getUztwc()
    {
        return _uztwc;
    }

    void setUzfwc(final double uzfwc)
    {
        _uzfwc = uzfwc;
    }

    double getUzfwc()
    {
        return _uzfwc;
    }

    void setLztwc(final double lztwc)
    {
        _lztwc = lztwc;
    }

    double getLztwc()
    {
        return _lztwc;
    }

    void setLzfsc(final double lzfsc)
    {
        _lzfsc = lzfsc;
    }

    double getLzfsc()
    {
        return _lzfsc;
    }

    void setLzfpc(final double lzfpc)
    {
        _lzfpc = lzfpc;
    }

    double getLzfpc()
    {
        return _lzfpc;
    }

    void setAdimc(final double adimc)
    {
        _adimc = adimc;
    }

    double getAdimc()
    {
        return _adimc;
    }
}
