package ohd.hseb.ohdutilities.sshp.sshpChpsExtractor;

import java.net.MalformedURLException;
import java.util.Date;

import nl.wldelft.fews.system.pi.FewsPiService;
import ohd.hseb.util.Logger;

import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;

/**
 * @author Cham Pham
 * @since 01/15/2010
 */

public class WrapFewsPiService
{
    public static Logger _logger = null;
    private static FewsPiService _defaultProxy = null;
    private static boolean _proxyCannotBeLoaded = false;
    private static String _serverInfo = null;

    public synchronized static void initializeDefaultProxy()
    {
        if(_proxyCannotBeLoaded)
        {
            return;
        }

        _logger.log(Logger.DEBUG, "SSHP extractor utility establishing connection to CHPS database.");

        _logger.log(Logger.DEBUG, "serverInfo: " + _serverInfo);

        _defaultProxy = getWebServiceProxy();

        _logger.log(Logger.DEBUG,
                    "SSHP extractor utility connection established successfully ("
                        + new Date(System.currentTimeMillis()) + ")");
    }

    private static FewsPiService getWebServiceProxy()
    {
        final ObjectServiceFactory serviceFactory = new ObjectServiceFactory();

        final Service service = serviceFactory.create(FewsPiService.class);

        final XFireProxyFactory proxyFactory = new XFireProxyFactory();

        Object proxy;
        try
        {
            proxy = proxyFactory.create(service, _serverInfo);

            if(proxy != null && proxy instanceof FewsPiService)
            {
                return (FewsPiService)proxy;
            }
            else
            {
                _proxyCannotBeLoaded = true;
                return null;
            }
        }
        catch(final MalformedURLException e)
        {
            _proxyCannotBeLoaded = true;
            return null;
        }
    }

    public static FewsPiService getDefaultProxy()
    {
        if(_defaultProxy == null)
        {
            initializeDefaultProxy();
        }
        return _defaultProxy;
    }

    public static boolean getProxyCannotBeLoaded()
    {
        return _proxyCannotBeLoaded;
    }

    public static void setLog(final Logger log)
    {
        _logger = log;
    }

    public static void getFewsPiServiceImpl(final String uri)
    {
        _serverInfo = uri;
    }

}