/*
 * Created on August 25, 2005
 */

/**
 * @author Bryon Lawrence This retrieves the contents of the coord_xxxx.dat file. For a RFC, xxxx is the name of the
 *         office. For a WFO, xxxx is 'host'.
 */
package ohd.hseb.prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import ohd.hseb.util.AppsDefaults;

public class GeoData
{

    public static String _filePath;
    private int _southWestColumn = -1;
    private int _southWestRow = -1;
    private int _numberOfColumns = -1;
    private int _numberOfRows = -1;

    public GeoData() throws Exception
    {
        buildFilePath();
        readGeoData();
    }

    public GeoData(final String filePath) throws Exception
    {
        _filePath = filePath;
        readGeoData();
    }

    protected void buildFilePath()
    {
        String officeName = "";
        String geoDataDir = "";
        final AppsDefaults appsDefaults = new AppsDefaults();

        officeName = appsDefaults.getToken("st3_rfc");
        geoDataDir = appsDefaults.getToken("geo_data");

        _filePath = geoDataDir + "/" + officeName + "/ascii/coord_" + officeName + ".dat";
    }

    protected void readGeoData() throws Exception
    {
        if(!new File(_filePath).exists())
            throw new Exception("Geo File not found: " + _filePath);
        final BufferedReader _reader = new BufferedReader(new FileReader(_filePath));

        _southWestColumn = Integer.parseInt(_reader.readLine());
        _southWestRow = Integer.parseInt(_reader.readLine());
        _numberOfColumns = Integer.parseInt(_reader.readLine());
        _numberOfRows = Integer.parseInt(_reader.readLine());

        _reader.close();

    }

    public int getSouthwestColumn()
    {
        return _southWestColumn;
    }

    public int getSouthwestRow()
    {
        return _southWestRow;
    }

    public int getNumColumns()
    {
        return _numberOfColumns;
    }

    public int getNumRows()
    {
        return _numberOfRows;
    }

    public String getFilePath()
    {
        return _filePath;
    }

}
