package ohd.hseb.time;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import ohd.hseb.util.fews.OHDConstants;

public class FasterDateTimeFormatter implements DateTimeFormatter
{

    static ThreadLocal<SimpleDateFormat> _formatThreadLocal;

    static
    {

        _formatThreadLocal = new ThreadLocal<SimpleDateFormat>()
        {
            @Override
            public SimpleDateFormat initialValue()
            {
                final SimpleDateFormat sdf = new SimpleDateFormat(OHDConstants.DATE_TIME_FORMAT_STR);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf;
            }
        };
    }

    public FasterDateTimeFormatter()
    {

    }

    public String format(final long timeInMillis)
    {
        final SimpleDateFormat formatter = _formatThreadLocal.get();
        return formatter.format(new Date(timeInMillis));

    }

}
