package ohd.hseb.util;

import java.util.ArrayList;

public class Pair<T, U> {

	private T first;
	private U second;

	public Pair(T first, U second) {
		this.first = first;
		this.second = second;
	}
	
	public T first() {return first;}
	public U second() {return second;}
	
	public static Pair<String, String> parts(String representation) {	
		String firstpart="";
		String secondpart="";
		
		int indexOfSplittingComma = findFirstCommaNotEnclosedInParens(representation);
		
		firstpart = removeSurroundingParens(
				representation.substring(0, indexOfSplittingComma).trim());
		secondpart = removeSurroundingParens(
				representation.substring(indexOfSplittingComma+1).trim());
	
		return new Pair<String, String>(firstpart, secondpart);
	}
	
	public static ArrayList<Pair<String,String>> multiplePairs(String representation) {	
		String firstpart="";
		String secondpart="";
		
		ArrayList<Pair<String,String>> listOfPairs = new ArrayList<Pair<String,String>>();
		int indexOfSplittingComma = findFirstCommaNotEnclosedInParens(representation);
		int startingIndex = 0;
		
		while (indexOfSplittingComma != -1) {
			String pairAsString = removeSurroundingParens(representation.substring(startingIndex, indexOfSplittingComma).trim());
			int indexToCommaInPair = pairAsString.indexOf(',');
			firstpart = pairAsString.substring(startingIndex,indexToCommaInPair).trim();
			secondpart = pairAsString.substring(indexToCommaInPair+1).trim();
			listOfPairs.add(new Pair<String, String>(firstpart, secondpart));
			representation = removeSurroundingParens(representation.substring(indexOfSplittingComma+1));
			indexOfSplittingComma = findFirstCommaNotEnclosedInParens(representation);
		}
		
		// get last pair
		String pairAsString = removeSurroundingParens(representation.trim());
		int indexToCommaInPair = pairAsString.indexOf(',');
		firstpart = pairAsString.substring(startingIndex,indexToCommaInPair).trim();
		secondpart = pairAsString.substring(indexToCommaInPair+1).trim();
		listOfPairs.add(new Pair<String, String>(firstpart, secondpart));
		return listOfPairs;
	}

	private static int findFirstCommaNotEnclosedInParens(String representation) {
		for (int index : indicesOfCommas(representation)) {
			String substring = representation.substring(0,index);
			if (noOpenParensIn(substring)) {
				return index;
			}
		}
		return -1;
	}

	private static String removeSurroundingParens(String fragment) {
		if (fragment.startsWith("(")) 
			return fragment.substring(1, fragment.length()-1);
		return fragment;
	}

	public static boolean noOpenParensIn(String fragment) {
		return (countOf(fragment, "(") <= countOf(fragment, ")"));
	}

	public static int countOf(String searchIn, String searchFor) {
		int x=0;
		int i=searchIn.indexOf(searchFor);
		while (i!=-1) {
			x++;
			i = searchIn.indexOf(searchFor, i+1);
		}
		return x;
	}

	public static ArrayList<Integer> indicesOfCommas(String representation) {
		ArrayList<Integer> l = new ArrayList<Integer>();
		
		int i=representation.indexOf(",");
		while (i!=-1) {
			l.add(i);
			i = representation.indexOf(",", i+1);
		}
		return l;
	}

	public boolean equals(Object compareTo) {
		if (compareTo==this) return true;
		if (compareTo==null) return false;
		if (compareTo.getClass()!=this.getClass()) return false;
		
		Pair otherPair = (Pair) compareTo;
		if (!otherPair.first.equals(this.first)) return false;
		if (!otherPair.second.equals(this.second)) return false;
		return true;
	}
	
	public String toString() {
		return "(" + first.toString() + ", " + second.toString() + ")";
	}
	
}
