package ohd.hseb.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import ohd.hseb.time.DateTime;

public class StringUtilities {

	public static String right(String value, int number) {
		
		isSubstringValid(value, number);
		
		return value.substring(value.length() - number, value.length());
	}

	public static String repeat(String value, int timesToRepeat) {
		StringBuilder builder = new StringBuilder(value.length()*timesToRepeat);
		for (int i=1; i<=timesToRepeat; i++) {
			builder.append(value);
		}
		return builder.toString();
	}

	public static String repeat(char value, int timesToRepeat) {
		StringBuilder builder = new StringBuilder(timesToRepeat);
		for (int i=1; i<=timesToRepeat; i++) {
			builder.append(value);
		}
		return builder.toString();
	}
	
	public static String rightJustify(char justifyWith, int value, int totalLength) {
		return right(repeat(justifyWith, totalLength) + value, totalLength);
	}
	
	public static String rightJustify(char justifyWith, String value, int totalLength) {
		return right(repeat(justifyWith, totalLength) + value, totalLength);
	}
	
	public static String rightJustify(String value, int totalLength) {
		return right(repeat(" ", totalLength) + value, totalLength);
	}
	
	public static String rightJustify(int value, int totalLength) {
		return rightJustify(Integer.toString(value), totalLength);
	}

	public static String rightJustify(double value, int totalLength) {
		return rightJustify(Double.toString(value), totalLength);
	}
	
	public static String leftJustify(String value, int totalLength) {
		return left(value + repeat(" ", totalLength), totalLength);
	}
	
	public static String leftJustify(int value, int totalLength) {
		return leftJustify(Integer.toString(value), totalLength);
	}
	
	public static String leftJustify(double value, int totalLength){
		return leftJustify(Double.toString(value), totalLength);
	}
	
	public static String left(String value, int number){
		isSubstringValid(value, number);
		return value.substring(0, number);
	}

	private static void isSubstringValid(String value, int number){
		if((value.length() - number) < 0) {
			throw new IndexOutOfBoundsException(value+ " only has "+ value.length() + 
					" characters; cannot return the right "+number);
		}
	}
	
	public static String[] convertToStrings(DateTime[] carryoverDates) {
		String converted[] = new String[carryoverDates.length];
		for (int i=0; i<carryoverDates.length; i++) {
			converted[i] = carryoverDates[i].flatten() + "Z";
		}
		return converted;
	}
	
	public static List<String> convertToStrings(List<DateTime> dateList) {
		List<String> list = new ArrayList<String>(dateList.size());
		for (DateTime time : dateList) {
			list.add(time.flatten() + "Z");
	}
	return list;
	}
	
	public static String concatenate(String[] list) {
		StringBuilder builder = new StringBuilder();
		for (String item: list) {
			builder.append(item);
			builder.append(" ");
		}
		return builder.toString().trim();
	}
	
	public static String concatenate(List<String> list) {
		return concatenate(list.toArray(new String[list.size()]));
	}
	
	
	public static String concatenateWithFieldWidth(String[] list, int fieldWidth) {
		StringBuilder builder = new StringBuilder();
		for (String item: list) {
			builder.append(StringUtilities.leftJustify(item,fieldWidth));
		}
		return builder.toString().trim();
	}
	
	public static String concatenateWithFieldWidth(List<String> list, int fieldWidth) {
		return concatenateWithFieldWidth(list.toArray(new String[list.size()]), fieldWidth);
	}

	public static String getTokenNumberUsingDelimeter(String stringToSearch, int tokenToReturn, String delimeter) {
		return stringToSearch.trim().split(delimeter)[tokenToReturn - 1]; 
	}

	public static String getNextTokenUsingDelimeter(String stringToSearch, String firstToken, String delimeter) {
		 
		return stringToSearch.trim().split(firstToken)[1].split(delimeter)[1];
	}

    /**
     * Convert "ABC"(or "aBc") to "Abc", "ST CROIX" to "St Croix", and "ABC O P" to "Abc O P".
     */
    public static String convertStringToCamelCase(final String origStr)
    {
        final StringTokenizer wordFinder = new StringTokenizer(origStr);//parse the String with " " limits
        final StringBuilder strBuilder = new StringBuilder();
    
        while(wordFinder.hasMoreTokens())
        {
            final String word = wordFinder.nextToken();
    
            strBuilder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
    
        return strBuilder.toString().trim();
    }
	
}