/*
 * Created on Oct 8, 2003
 */
package ohd.hseb.util;

/**
 * @author GobsC
 */

public class TimeHelper
{

    public static final long MILLIS_PER_HOUR = 1000 * 60 * 60;
    public static final long MILLIS_PER_DAY = 24 * MILLIS_PER_HOUR;

    /**
     * This method truncates the millis by the amount of hoursToTruncate equivalent millis. For example, the millis of
     * "1910-03-22 18:00:00", with 24 hoursToTruncate, becomes "1910-03-22 00:00:00". The millis of
     * "1910-03-22 17:59:00", with 1 hoursToTruncate, becomes "1910-03-22 17:00:00".
     */
    public static long truncateTimeInMillisToNearestHour(final long timeInMillis, final int hoursToTruncate)
    {

//        final String header = "TimeHelper.truncateTimeInMillisToNearestHour(): ";
        long truncatedTime = 0;

        if(timeInMillis >= 0)
        {//the millis is after or equal to 1970-01-01 00:00:00 GMT

            truncatedTime = truncatePositiveTimeInMillisToNearestHour(timeInMillis, hoursToTruncate);
        }
        else
        {//the millis is before 1970-01-01 00:00:00 GMT

            truncatedTime = truncateNegativeTimeInMillisToNearestHour(timeInMillis, hoursToTruncate);
        }

//        System.out.println(header + " original timeInMillis = "
//            + DbTimeHelper.getDateTimeStringFromLongTime(timeInMillis) + " = " + timeInMillis);
//
//        System.out.println(header + " result = " + DbTimeHelper.getDateTimeStringFromLongTime(truncatedTime) + " = "
//            + truncatedTime);

        return truncatedTime;
    }

    private static long truncatePositiveTimeInMillisToNearestHour(final long timeInMillis, final int hoursToTruncate)
    {
        final long roundingAmountInMillis = hoursToTruncate * MILLIS_PER_HOUR;

        long roundedTimeInMillis = timeInMillis;
        roundedTimeInMillis /= roundingAmountInMillis;
        roundedTimeInMillis *= roundingAmountInMillis;

        return roundedTimeInMillis;

    }

    private static long truncateNegativeTimeInMillisToNearestHour(final long timeInMillis, final int hoursToTruncate)
    {
        final long roundingAmountInMillis = hoursToTruncate * MILLIS_PER_HOUR;

        long roundedTimeInMillis = timeInMillis;
        roundedTimeInMillis /= roundingAmountInMillis;
        roundedTimeInMillis *= roundingAmountInMillis;

        //if roundedTimeInMillis == timeInMillis, nothing needs to be truncated
        if(roundedTimeInMillis != timeInMillis)
        {
            roundedTimeInMillis -= roundingAmountInMillis;
        }

        return roundedTimeInMillis;

    }

    /**
     * This method rounds up a millis corresponding to "2010-03-22 18:29:00" to a new millis corresponding to
     * "2010-03-22 18:00:00", while a millis corresponding to "2010-03-22 18:30:00" to a new millis corresponding to
     * "2010-03-22 19:00:00"
     */
    public static long roundTimeInMillisToNearestHour(final long timeInMillis)
    {
        final long halfHourInMillis = MILLIS_PER_HOUR / 2;
        final long roundedTime = truncateTimeInMillisToNearestHour(timeInMillis + halfHourInMillis, 1);

        return roundedTime;
    }
//  --------------------------------------------------------------------------

}
