/*
 * Created on May 24, 2004
 */
package ohd.hseb.util;

import ohd.hseb.db.DbTimeHelper;
import ohd.hseb.time.DateTime;
import ohd.hseb.util.fews.OHDConstants;

/**
 * @author GobsC
 */
public class XmrgGrid
{
    public static final double OFF_GRID_VALUE = -8888.0;

    private long _time = 0;

    private double[][] _gridValuesArray = null;

    private boolean _isValid = true;

    private int _rowCount = 0;
    private int _colCount = 0;

    private int _baseRow = 0; //southern row
    private int _baseCol = 0; // western col

//  -----------------------------------------------------------------------------------
    public static XmrgGrid getInvalidGrid(final long time)
    {
        final XmrgGrid grid = new XmrgGrid(time);

        grid.setIsValid(false);

        return grid;
    }

//  -----------------------------------------------------------------------------------

    public XmrgGrid(final long time)
    {
        _time = time;
    }

    //  -----------------------------------------------------------------------------------

    public XmrgGrid(final long time,
                    final int southernRowIndex,
                    final int westernColIndex,
                    final int rowCount,
                    final int colCount)
    {

        _time = time;

        // new way
        _rowCount = rowCount;
        _colCount = colCount;

        _baseRow = southernRowIndex;
        _baseCol = westernColIndex;

        _gridValuesArray = new double[_rowCount][_colCount];

        return;
    }

//  -----------------------------------------------------------------------------------

    public void setValue(final int hrapRow, final int hrapCol, final double value)
    {
        final int rowIndex = hrapRow - _baseRow;
        final int colIndex = hrapCol - _baseCol;

        _gridValuesArray[rowIndex][colIndex] = value;

        return;
    }

//  -----------------------------------------------------------------------------------

    public double[][] getValuesArray()
    {
        return _gridValuesArray;
    }

//  -----------------------------------------------------------------------------------

    public double getValue(final int hrapRow, final int hrapCol)
    {
        final int rowIndex = hrapRow - _baseRow;
        final int colIndex = hrapCol - _baseCol;

        double value = OFF_GRID_VALUE;

        //Chip CHANGE 8/23/05  
        if((rowIndex > -1) && (rowIndex < _rowCount) && (colIndex > -1) && (colIndex < _colCount))
        {
            value = _gridValuesArray[rowIndex][colIndex];
        }
        else
        {

            // System.out.println("XmrgGrid.getValue(): attempting to access " +
            //         "rowIndex = " + rowIndex + "  colIndex = " + colIndex);

            // System.out.print("  Row Values should be >= 0 < " + _rowCount);
            // System.out.println("  and column values should be >= 0 < " + _colCount);   

        }
        return value;
    }

    //  -----------------------------------------------------------------------------------

    public void setTime(final long time)
    {
        _time = time;
    }

//  -----------------------------------------------------------------------------------

    public long getTime()
    {
        return _time;
    }

//  -----------------------------------------------------------------------------------
    @Override
    public String toString()
    {
        final StringBuffer buffer = new StringBuffer();
        double value = 0;

        buffer.append("time = " + DateTime.getDateTimeStringFromLong(_time,OHDConstants.GMT_TIMEZONE) + "\n");
        for(int i = 0; i < _rowCount; i++)
        {
            for(int j = 0; j < _colCount; j++)
            {
                value = _gridValuesArray[i][j];

                if(value > 0.0)
                {
                    buffer.append("hrapRow = " + i + " hrapCol = " + j + " value = " + value)
                          .append(OHDConstants.NEW_LINE);
                }
            }

        }

        return buffer.toString();

    }

//  -----------------------------------------------------------------------------------

    public void setIsValid(final boolean isValid)
    {
        _isValid = isValid;
    }

//  -----------------------------------------------------------------------------------

    public boolean isValid()
    {
        return _isValid;
    }

    public int getBaseRow()
    {
        return _baseRow;
    }

    public int getBaseCol()
    {
        return _baseCol;
    }

    public int getRowCount()
    {
        return _rowCount;
    }

    public int getColCount()
    {
        return _colCount;
    }

//  -----------------------------------------------------------------------------------

}
