package ohd.hseb.util.data;

import java.util.Calendar;

import ohd.hseb.util.misc.HCalendar;
import ohd.hseb.util.misc.Messenger;

// Correct the initial year problem for ESP data. Only the forecast months of Oct., Nov., and Dec. are needed to be
// corrected.
// Thus, this program will not work for other forecast months
// Author: Zhengtao Cui
// Date: 6/18/2012
// Reference: ESPData.Java

public class CorrectESPData
{
    public static void main(final String args[])
    {
        final int[] testlevels = {Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT,
            Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT,
            Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT, Messenger.ALWAYS_PRINT};

        Messenger.initMsg(-1, null, "stdout", testlevels);

//        System.out.println("=========================================");
//        System.out.println("ESPData version " + SoftwareVersionNumbers.ESPDATA_VERSION + "\n");
//        System.out.println("=========================================");

        //Process the arguments.
        if((args.length != 1))
        {
            System.out.println("");
            System.out.println("Invalid command line.  The execution command is:");
            System.out.println("");
            System.out.println("    <program> <file> <hsDebug>");
            System.out.println("");
            System.out.println("where <file> is the file to read in ");
            System.out.println("");
            return;
        }

        try
        {
            ESPData data;

            data = new ESPData(args[0], true, false);

            final int totalnumberofsamples = data.getSampleSize();

            data._iy = data._iy - 1;
            int hour;

            for(int i = 0; i < totalnumberofsamples; i += data._numberPerTrace)
            {
                final Calendar sampledate = data.getValueAsDate(i, 0);
                sampledate.add(Calendar.YEAR, -1);
                final Calendar temp = (Calendar)sampledate.clone();
                for(int j = i; j < i + 2; j++)
                {
                    hour = data.getValueAsDate(j, 0).get(Calendar.HOUR_OF_DAY);
                    temp.set(Calendar.HOUR_OF_DAY, hour);
                    data.setValue(j, 0, temp);
                }
                for(int j = i + 2; j < i + data._numberPerTrace - 3; j += 4)
                {
                    temp.add(Calendar.DAY_OF_YEAR, 1);
                    hour = data.getValueAsDate(j, 0).get(Calendar.HOUR_OF_DAY);
                    temp.set(Calendar.HOUR_OF_DAY, hour);
                    data.setValue(j, 0, temp);
                    hour = data.getValueAsDate(j + 1, 0).get(Calendar.HOUR_OF_DAY);
                    temp.set(Calendar.HOUR_OF_DAY, hour);
                    data.setValue(j + 1, 0, temp);
                    hour = data.getValueAsDate(j + 2, 0).get(Calendar.HOUR_OF_DAY);
                    temp.set(Calendar.HOUR_OF_DAY, hour);
                    data.setValue(j + 2, 0, temp);
                    hour = data.getValueAsDate(j + 3, 0).get(Calendar.HOUR_OF_DAY);
                    temp.set(Calendar.HOUR_OF_DAY, hour);
                    data.setValue(j + 3, 0, temp);
                }
                temp.add(Calendar.DAY_OF_YEAR, 1);
                hour = data.getValueAsDate(i + data._numberPerTrace - 1, 0).get(Calendar.HOUR_OF_DAY);
                temp.set(Calendar.HOUR_OF_DAY, hour);
                data.setValue(i + data._numberPerTrace - 1, 0, temp);
                hour = data.getValueAsDate(i + data._numberPerTrace - 2, 0).get(Calendar.HOUR_OF_DAY);
                temp.set(Calendar.HOUR_OF_DAY, hour);
                data.setValue(i + data._numberPerTrace - 2, 0, temp);
                hour = data.getValueAsDate(i + data._numberPerTrace - 3, 0).get(Calendar.HOUR_OF_DAY);
                temp.set(Calendar.HOUR_OF_DAY, hour);
                data.setValue(i + data._numberPerTrace - 3, 0, temp);
            }

            double startjhr = data.getSmallest(0);

            startjhr += data._nlstz;

//            final Calendar startdate = HCalendar.computeCalendarFromJulianHour((int)startjhr);

            double endjhr = data.getLargest(0);
            endjhr += data._nlstz;

            data._idarun = ((int)startjhr - 6) / 24 + 1;
            data._ldarun = (int)endjhr / 24 + 1;
            if(HCalendar.isLeapYear(data._runStart.get(Calendar.YEAR) - 1))
            {
                data._idarun += 1;
            }
            if(HCalendar.isLeapYear(data._runEnd.get(Calendar.YEAR) - 1))
            {
                data._ldarun += 1;
            }

//            if(HCalendar.isLeapYear(data._fcstStart.get(Calendar.YEAR)))
//            {
//                data._ijdlst = data._ijdlst - 366;
//                data._ljdlst = data._ljdlst - 366;
//            }
//            else
//            {
//                data._ijdlst = data._ijdlst - 365;
//                data._ljdlst = data._ljdlst - 365;
//            }

//            data._fcstStart = HCalendar.computeCalendarFromJulianHour((data._ijdlst - 1) * 24 + data._ihlst
//                - data._nlstz);
//            data._fcstEnd = HCalendar.computeCalendarFromJulianHour((data._ljdlst - 1) * 24 + data._lhlst - data._nlstz);
            data._runStart = HCalendar.computeCalendarFromJulianHour((data._idarun - 1) * 24 + data._ihlst
                - data._nlstz);
            data._runEnd = HCalendar.computeCalendarFromJulianHour((data._ldarun - 1) * 24 + data._lhlst - data._nlstz);

            //Dump the header if output level is at least 0.
//            System.out.println("##################### File Contents Read In: ####################");
//            if(outputlevel >= 0)
//            {
//            data.dumpHeader();
//            data.dumpProcessedHeader();
//            }
            //Dump out data if at least 1.
//            if(outputlevel >= 1)
//            {
//                if(dateprint)
//                {
//            data.dumpDataUsingDates();
//                }
//                else
//                {
//                    data.dumpData();
//                }
//            }
//            System.out.println("#################################################################");
//            System.out.println("");
//            System.out.println("");
            data.writeBinaryOutputFile();

        }
        catch(final ESPDataException e)
        {
            System.out.println("FAILURE!!!!!!");
        }

    }
}
