/*
 * Created on Jun 13, 2006 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.data;

import java.util.Arrays;

/**
 * Generic class to deal with (x, y1, y2, ...) data points. The y-values are stored in an array, which is defined in the
 * constructor.
 * 
 * @author hank
 */
public class DataPoint
{

    double _x;
    double[] _y;

    /**
     * @param numberOfYVars The number of y-values to deal with.
     */
    public DataPoint(final int numberOfYVars)
    {
        _x = DataSet.MISSING;
        _y = new double[numberOfYVars];
        int i;
        for(i = 0; i < numberOfYVars; i++)
        {
            _y[i] = DataSet.MISSING;
        }
    }

    /**
     * Assmes only 1 y value.
     * 
     * @param x
     * @param y
     */
    public DataPoint(final double x, final double y)
    {
        _x = x;
        _y = new double[1];
        _y[0] = y;
    }

    /**
     * Assumes exactly 2 y values.
     * 
     * @param x
     * @param y1
     * @param y2
     */
    public DataPoint(final double x, final double y1, final double y2)
    {
        _x = x;
        _y = new double[2];
        _y[0] = y1;
        _y[1] = y2;
    }

    public double getX()
    {
        return _x;

    }

    public double getY(final int index)
    {
        return _y[index];
    }

    public void setX(final double x)
    {
        _x = x;

    }

    public void setY(final int index, final double y)
    {
        _y[index] = y;
    }

    public int getNumberOfYVariables()
    {
        return _y.length;
    }

    @Override
    public String toString()
    {
        String result = "DataPoint[x = " + _x + "; y's = ";

        int i;
        for(i = 0; i < _y.length; i++)
        {
            result += "" + _y[i];
            if(i < _y.length - 1)
            {
                result += ", ";
            }
        }
        result += "] ";
        return result;
    }

    @Override
    public boolean equals(final Object base)
    {
        final DataPoint check = (DataPoint)base;
        if((_x == check._x) && Arrays.equals(_y, check._y))
        {
            return true;
        }
        return false;
    }
}
