/*
 * Created on Sep 16, 2005 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.data;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * This class uses a DataSet object, passed into the constructor, as a source for a TableModel.
 * 
 * @author hank To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code
 *         Generation&gt;Code and Comments
 */
public class TableModelData implements TableModel
{
    public static final String CLASSNAME = "TableModelData";

    DataSet _data;
    boolean[][] _editable;
    String[] _columnNames;

    /**
     * Constructor, taking a DataSet as input.
     */
    public TableModelData(final DataSet data)
    {
        _data = data;

        //Create the editable double array.
        _editable = new boolean[_data.getSampleSize()][_data.getNumberOfVariables()];
        int i, j;
        for(i = 0; i < _editable.length; i++)
        {
            for(j = 0; j < _editable[i].length; j++)
            {
                _editable[i][j] = true;
            }
        }

        //Create the columnNames array to be all default names.
        _columnNames = new String[_data.getNumberOfVariables()];
        for(i = 0; i < _columnNames.length; i++)
        {
            _columnNames[i] = "COLUMN" + i;
        }
    }

    /**
     * Sets the editable property of a cell for the TableModel interface.
     * 
     * @param rowIndex Row to set.
     * @param columnIndex Column to set.
     * @param editable Editable setting: true or false.
     */
    public void setCellEditable(final int rowIndex, final int columnIndex, final boolean editable)
    {
        if((rowIndex < _data.getSampleSize()) && (rowIndex >= 0) && (columnIndex < _data.getNumberOfVariables())
            && (columnIndex >= 0))
        {
            _editable[rowIndex][columnIndex] = editable;
        }
    }

    public void setColumnName(final int columnIndex, final String name)
    {
        if((columnIndex < _data.getNumberOfVariables()) && (columnIndex >= 0))
        {
            _columnNames[columnIndex] = name;
        }
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount()
    {
        return _data.getNumberOfVariables();
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount()
    {
        return _data.getSampleSize();
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(final int rowIndex, final int columnIndex)
    {
        if((rowIndex < _data.getSampleSize()) && (rowIndex >= 0) && (columnIndex < _data.getNumberOfVariables())
            && (columnIndex >= 0))
        {
            return _editable[rowIndex][columnIndex];
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    @SuppressWarnings("unchecked")
    public Class getColumnClass(final int columnIndex)
    {
        return Double.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    public Object getValueAt(final int rowIndex, final int columnIndex)
    {
        return Double.valueOf(_data.getValue(rowIndex, columnIndex));
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
     */
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex)
    {
        _data.setValue(rowIndex, columnIndex, ((Double)(aValue)).doubleValue());
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(final int columnIndex)
    {
        return _columnNames[columnIndex];
    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#addTableModelListener(javax.swing.event.TableModelListener)
     */
    public void addTableModelListener(final TableModelListener l)
    {

    }

    /*
     * (non-Javadoc)
     * @see javax.swing.table.TableModel#removeTableModelListener(javax.swing.event.TableModelListener)
     */
    public void removeTableModelListener(final TableModelListener l)
    {

    }

    public static void main(final String[] args)
    {
    }
}
