/*
 * Created on Mar 6, 2008
 * 
 * To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and
 * Comments
 */
package ohd.hseb.util.fews.ensmodels.aggregator;

import java.util.List;

/**
 * Interface defining a computer that can be used by FewsRegularTimeSeriesAggregator to aggregate a time series. Its one
 * method defines how to compute a single member of the aggregated time series given the window of time that pertains to
 * that member and a list of measurement indices within the time series being aggregated that overlap the time window.
 * <br>
 * ISSUES:<br>
 * 1. Each aggregator must decide what to do with MISSING values indicated by the measurementIndicesAffectingWindow
 * list. <br>
 * 2. Each aggregator must decide if values that only touch on the very end of the aggregation time window (those with a
 * 0 width overlap or getAggregator().determineOverlappingWindow() return value of null) are to be included in the
 * examination. This may have an impact on how the aggregator behaves relative to MISSING values (it may behave
 * differently if there is no time overlap).<br>
 * <br>
 * A default implementation of this is available in the abstract class DefaultAggregationComputer. Any implementer
 * should subclass that default.
 * 
 * @author hank
 */
public interface AggregationComputer
{

    /**
     * Sets the aggregator that is calling the computer.
     * 
     * @param agg
     */
    public void setAggregator(FewsRegularTimeSeriesAggregator agg);

    /**
     * Computes an aggregated value. Use methods within getAggregator() as needed, particularly the following:<br>
     * <br>
     * determineOverlappingWindow -- Compute the window of overlap between the affected window of a measurement and the
     * aggregation window. Returns null if the overlap is only a touching (i.e. 0 overlap).<br>
     * getAffectedTimeWindow* -- Returns the lower or upper bounds of the time window affected by a measurement.<br>
     * getTimeSeries -- Returns the time series being aggregated; used to acquire the measurement values.<br>
     * <br>
     * 
     * @param timeLB The lower bound in millis of the aggregation window.
     * @param timeUB The upper bound in millis of the aggregation window.
     * @param measurementIndicesAffectingWindow The indices of measurements affecting this time window. In otherwords,
     *            every item in this List is an index of a measurement whose affected time window touches the window
     *            [timeLB, timeUB]. Note that it may only touch at the ends (the affected window UB may euqal time LB,
     *            for example).
     * @return A single aggregated value for the times.
     */
    public double computeAggregatedValue(long timeLB, long timeUB, List<Integer> measurementIndicesAffectingWindow);
}
