/*
 * Created on Mar 18, 2008 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.fews.ensmodels.aggregator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import ohd.hseb.util.misc.MiscTools;

public abstract class AggregationComputerFactory
{

    public final static String DEFAULT_AGGREGATION_COMPUTER_PACKAGE = "ohd.hseb.ensmodels.aggregator.computers";
    public final static String DEFAULT_AGGREGATION_CLASS_SUFFIX = "Computer";

    public static AggregationComputer loadAggregationComputer(FewsRegularTimeSeriesAggregator tsAggregator,
                                                              String classNameOrType) throws AggregationException
    {
        AggregationComputer computer = null;

        //Build the class name.  It is either the passed in string or one of the defaults
        //if the passed in class does not exist.
        String className = classNameOrType;
        try
        {
//            Class aggClass = 
            Class.forName(classNameOrType);
        }
        catch(ClassNotFoundException cnfe)
        {
            className = DEFAULT_AGGREGATION_COMPUTER_PACKAGE + "." + classNameOrType + DEFAULT_AGGREGATION_CLASS_SUFFIX;
        }

        try
        {
            Class<?> aggClass = Class.forName(className);
            computer = (AggregationComputer)aggClass.getDeclaredConstructor().newInstance();
            computer.setAggregator(tsAggregator);
        }
        catch(ClassNotFoundException e)
        {
            throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
                + e.getMessage());
        }
        catch(IllegalArgumentException e)
        {
            throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
                + e.getMessage());
        }
        catch(SecurityException e)
        {
            throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
                + e.getMessage());
        }
        catch(InstantiationException e)
        {
            throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
                + e.getMessage());
        }
        catch(IllegalAccessException e)
        {
            throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
                + e.getMessage());
        } 
        catch (InvocationTargetException e) 
        {
			throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
	                + e.getMessage());
		} 
        catch (NoSuchMethodException e) 
        {
			throw new AggregationException("Cannot load aggregation computer " + classNameOrType + ": "
	                + e.getMessage());
		}

        return computer;

    }

    /**
     * @return A List of Strings, where each is the full path name of one aggregator that was found. All aggregators
     *         must be placed in the package ohd.hseb.ensmodels.aggregator.computers.
     */
    public static List<String> obtainListOfAllAggregatorComputers()
    {
        List<String> results = new ArrayList<String>();
        int suffixLength = AggregationComputerFactory.DEFAULT_AGGREGATION_CLASS_SUFFIX.length();

        //+1 accounts for the period at the end
        int prefixLength = AggregationComputerFactory.DEFAULT_AGGREGATION_COMPUTER_PACKAGE.length() + 1;

        try
        {
            Class<?>[] classes = MiscTools.getClasses("ohd.hseb.ensmodels.aggregator.computers");
            for(int i = 0; i < classes.length; i++)
            {
                if(classes[i].getName().endsWith(AggregationComputerFactory.DEFAULT_AGGREGATION_CLASS_SUFFIX))
                {
                    results.add(classes[i].getName().substring(prefixLength,
                                                               classes[i].getName().length() - suffixLength));
                }
            }
        }
        catch(ClassNotFoundException cnfe)
        {
        }
        return results;
    }
}
