/*
 * Created on Mar 6, 2008
 * 
 * To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and
 * Comments
 */
package ohd.hseb.util.fews.ensmodels.aggregator;

import java.util.List;

/**
 * Default implementation of AggregationComputer. Be sure to set the FewsRegularTimeSeriesAggregator via setAggregator
 * in the constructor of any subclass. Also, the subclass must define computeAggregatedValue (see the javadoc for
 * AggregationComputer).
 * 
 * @author hank
 */
public abstract class DefaultAggregationComputer implements AggregationComputer
{

    private FewsRegularTimeSeriesAggregator _aggregator = null;

    public FewsRegularTimeSeriesAggregator getAggregator()
    {
        return _aggregator;
    }

    public void setAggregator(FewsRegularTimeSeriesAggregator agg)
    {
        _aggregator = agg;
    }

    public abstract double computeAggregatedValue(long timeLB, long timeUB,
            List<Integer> measurementIndicesAffectingWindow);
}
