/*
 * Created on Mar 6, 2008 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.fews.ensmodels.aggregator;

import ohd.hseb.util.fews.FewsRegularTimeSeries;
import ohd.hseb.util.fews.ensmodels.FewsEnsemble;

public class FewsEnsembleAggregator
{

    private final FewsEnsemble _ensemble;

    public FewsEnsembleAggregator(FewsEnsemble ensemble)
    {
        _ensemble = ensemble;
    }

    public FewsEnsemble aggregateEnsemble(long startTime, int aggregateIntervalInHours, String aggregationFullClassName) throws AggregationException
    {
        FewsEnsemble results = new FewsEnsemble();

        if(_ensemble.size() == 0)
        {
            return results;
        }

        results.setMemberTemplate(_ensemble.get(0));

        int i;
        for(i = 0; i < _ensemble.size(); i++)
        {
            FewsRegularTimeSeriesAggregator aggregator = new FewsRegularTimeSeriesAggregator(_ensemble.get(i));
            FewsRegularTimeSeries newSeries = aggregator.aggregateTimeSeries(startTime,
                                                                             aggregateIntervalInHours,
                                                                             aggregationFullClassName);
            results.add(newSeries);
        }

        //TODO Need to adjust template data type according to the aggregation... somehow.
        results.setEnsembleId(_ensemble.getEnsembleId());
        results.setMemberTemplate(results.get(0));
        results.applyTemplateToAllMembers();

        return results;
    }
    
    public FewsEnsemble disaggregateEnsemble( int disaggregatedIntervalInHours, FewsEnsemble originalFewsEnsemble, FewsEnsemble rawAggregatedEnsemble, boolean CPPAggregateMethod ) throws AggregationException
    {
        FewsEnsemble results = new FewsEnsemble();
        
        if ( _ensemble.size() == 0 )
        {
            return results;
        }
        
        results.setMemberTemplate( _ensemble.get(0));
        
        for ( int i = 0; i < _ensemble.size(); i++ )
        {
            FewsRegularTimeSeriesAggregator aggregator = new FewsRegularTimeSeriesAggregator(_ensemble.get( i ) );
            FewsRegularTimeSeries newSeries = aggregator.disaggregateTimeSeries( originalFewsEnsemble.get( i ), rawAggregatedEnsemble.get( i ), CPPAggregateMethod );
            results.add( newSeries);
        }
        
        results.setEnsembleId( _ensemble.getEnsembleId());
        results.setMemberTemplate( results.get(0 ));
        results.applyTemplateToAllMembers();
        
        return results;
    }

}
