package ohd.hseb.util.fews.ohdutilities;

import java.io.FileOutputStream;

import ohd.hseb.util.Logger;
import ohd.hseb.util.SortedProperties;
import ohd.hseb.util.fews.LegacyAdapter;
import ohd.hseb.util.fews.NwsrfsDataFileExtractor;
import ohd.hseb.util.fews.OHDConstants;

/**
 * This class is responsible for writing out any file (i.e text or binary files) to the format expected by the Legacy
 * (C/FORTRAN) version of the various models and for reading in the results and putting them back in to appropriate
 * objects so that XML that FEWS expects can be written out.
 * 
 * @author FewsPilot team
 */
public class LegacyUtilitiesAdapter extends LegacyAdapter
{

    /** binary executable path */
//    private String _pathToBin = "Modules/bin";
    private static final String ARGUMENTS_FILENAME = "arguments.txt";

    public LegacyUtilitiesAdapter(final String workDir, final Logger logger) throws Exception
    {
        _workDir = workDir;
        _logger = logger;

        _diagFileName = _workDir + "/" + OHDConstants.DIAGNOSTICS_FILENAME;

        _printDebugInfo = "" + logger.getPrintDebugInfo();

        // extract datatype and dataunit file from jar file
        _extractor = new NwsrfsDataFileExtractor(_workDir);
        _extractor.copyNwsrfsFilesFromClasspath();
    }

    /**
     * Instantiates a CommandAdapter and runs the external executable
     * 
     * @param args Arguments to be passed to external executable
     * @throws Exception
     */
    public void executeUtility(final String executableName, final SortedProperties properties) throws Exception
    {

        final String[] arguments = {_workDir + "/" + ARGUMENTS_FILENAME};

        // write out properties to arguments.txt file
        final FileOutputStream argsFile = new FileOutputStream(_workDir + "/" + ARGUMENTS_FILENAME);
        properties.store(argsFile, null);
        argsFile.close();

        //Execute the model
        executeLegacy(executableName, arguments);
    }

//    /**
//     * Get binary executable path
//     * 
//     * @return path to executable
//     */
//    public String getPathToBin()
//    {
//        return _pathToBin;
//    }
//
//    /**
//     * Set binary executable path
//     * 
//     * @param pathToBin - path to executable
//     */
//    public void setPathToBin(final String pathToBin)
//    {
//        _pathToBin = pathToBin;
//    }

}
