package ohd.hseb.util.fews.ohdutilities;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.Driver;

public abstract class UtilityDriver extends Driver
{
    //specific stuff for UtilityDriver can be added in this class; right now, nothing yet.

    public void executeDriver() throws Exception
    {
        execute();
    }

    /**
     * Run {@link Driver#runDriverValidation()} first. Then validate each input TS has enough data.
     */
    @Override
    protected void runDriverValidation() throws Exception
    {
        super.runDriverValidation(); //running Driver.runDriverValidation() first

        /* ----------------validate each input TS has enough data------------ */
        /*
         * some util programs, like EnsPost and CPCEnsPre, their input data period is not required to cover the period
         * defined in run_info.xml. So EnsPostModelDriver does not reach here: it overrides runDriverValidation()
         */
        for(final RegularTimeSeries rts: getTsList())
        {
            //check if has enough data
            rts.checkHasEnoughData(getInitialStateTime(), getComputationEndTime());
            _logger.log(Logger.DEBUG, "Input time series " + rts.getTimeSeriesType() + " has enough data.");
        }
    }

}
